/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ShortArray;

public class RepeatablePolygonSprite {
    private TextureRegion region;
    private float density;
    private boolean dirty = true;
    private Array<float[]> parts = new Array();
    private Array<float[]> vertices = new Array();
    private Array<short[]> indices = new Array();
    private int cols;
    private int rows;
    private float gridWidth;
    private float gridHeight;
    public float x = 0.0f;
    public float y = 0.0f;
    private Color color = Color.WHITE;
    private Vector2 offset = new Vector2();

    public void setPolygon(TextureRegion region, float[] vertices) {
        this.setPolygon(region, vertices, -1.0f);
    }

    public void setPolygon(TextureRegion region, float[] vertices, float density) {
        this.region = region;
        vertices = this.offset(vertices);
        Polygon polygon = new Polygon(vertices);
        Polygon tmpPoly = new Polygon();
        Polygon intersectionPoly = new Polygon();
        EarClippingTriangulator triangulator = new EarClippingTriangulator();
        Rectangle boundRect = polygon.getBoundingRectangle();
        if (density == -1.0f) {
            density = boundRect.getWidth() / (float)region.getRegionWidth();
        }
        float regionAspectRatio = (float)region.getRegionHeight() / (float)region.getRegionWidth();
        this.cols = (int)Math.ceil(density);
        this.gridWidth = boundRect.getWidth() / density;
        this.gridHeight = regionAspectRatio * this.gridWidth;
        this.rows = (int)Math.ceil(boundRect.getHeight() / this.gridHeight);
        int col = 0;
        while (col < this.cols) {
            int row = 0;
            while (row < this.rows) {
                float[] verts = new float[8];
                int idx = 0;
                verts[idx++] = (float)col * this.gridWidth;
                verts[idx++] = (float)row * this.gridHeight;
                verts[idx++] = (float)col * this.gridWidth;
                verts[idx++] = (float)(row + 1) * this.gridHeight;
                verts[idx++] = (float)(col + 1) * this.gridWidth;
                verts[idx++] = (float)(row + 1) * this.gridHeight;
                verts[idx++] = (float)(col + 1) * this.gridWidth;
                verts[idx] = (float)row * this.gridHeight;
                tmpPoly.setVertices(verts);
                Intersector.intersectPolygons(polygon, tmpPoly, intersectionPoly);
                verts = intersectionPoly.getVertices();
                if (verts.length > 0) {
                    this.parts.add(this.snapToGrid(verts));
                    ShortArray arr = triangulator.computeTriangles(verts);
                    this.indices.add(arr.toArray());
                } else {
                    this.parts.add(null);
                }
                ++row;
            }
            ++col;
        }
        this.buildVertices();
    }

    private float[] snapToGrid(float[] vertices) {
        int i = 0;
        while (i < vertices.length) {
            float numX = vertices[i] / this.gridWidth % 1.0f;
            float numY = vertices[i + 1] / this.gridHeight % 1.0f;
            if (numX > 0.99f || numX < 0.01f) {
                vertices[i] = this.gridWidth * (float)Math.round(vertices[i] / this.gridWidth);
            }
            if (numY > 0.99f || numY < 0.01f) {
                vertices[i + 1] = this.gridHeight * (float)Math.round(vertices[i + 1] / this.gridHeight);
            }
            i += 2;
        }
        return vertices;
    }

    private float[] offset(float[] vertices) {
        this.offset.set(vertices[0], vertices[1]);
        int i = 0;
        while (i < vertices.length - 1) {
            if (this.offset.x > vertices[i]) {
                this.offset.x = vertices[i];
            }
            if (this.offset.y > vertices[i + 1]) {
                this.offset.y = vertices[i + 1];
            }
            i += 2;
        }
        i = 0;
        while (i < vertices.length) {
            int n = i;
            vertices[n] = vertices[n] - this.offset.x;
            int n2 = i + 1;
            vertices[n2] = vertices[n2] - this.offset.y;
            i += 2;
        }
        return vertices;
    }

    private void buildVertices() {
        this.vertices.clear();
        int i = 0;
        while (i < this.parts.size) {
            float[] verts = this.parts.get(i);
            if (verts != null) {
                float[] fullVerts = new float[5 * verts.length / 2];
                int idx = 0;
                int col = i / this.rows;
                int row = i % this.rows;
                int j = 0;
                while (j < verts.length) {
                    fullVerts[idx++] = verts[j] + this.offset.x + this.x;
                    fullVerts[idx++] = verts[j + 1] + this.offset.y + this.y;
                    fullVerts[idx++] = this.color.toFloatBits();
                    float u = verts[j] % this.gridWidth / this.gridWidth;
                    float v = verts[j + 1] % this.gridHeight / this.gridHeight;
                    if (verts[j] == (float)col * this.gridWidth) {
                        u = 0.0f;
                    }
                    if (verts[j] == (float)(col + 1) * this.gridWidth) {
                        u = 1.0f;
                    }
                    if (verts[j + 1] == (float)row * this.gridHeight) {
                        v = 0.0f;
                    }
                    if (verts[j + 1] == (float)(row + 1) * this.gridHeight) {
                        v = 1.0f;
                    }
                    u = this.region.getU() + (this.region.getU2() - this.region.getU()) * u;
                    v = this.region.getV() + (this.region.getV2() - this.region.getV()) * v;
                    fullVerts[idx++] = u;
                    fullVerts[idx++] = v;
                    j += 2;
                }
                this.vertices.add(fullVerts);
            }
            ++i;
        }
        this.dirty = false;
    }

    public void draw(PolygonSpriteBatch batch) {
        if (this.dirty) {
            this.buildVertices();
        }
        int i = 0;
        while (i < this.vertices.size) {
            batch.draw(this.region.getTexture(), this.vertices.get(i), 0, this.vertices.get(i).length, this.indices.get(i), 0, this.indices.get(i).length);
            ++i;
        }
    }

    public void setColor(Color color) {
        this.color = color;
        this.dirty = true;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
        this.dirty = true;
    }
}

