/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.profiling;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.profiling.GLInterceptor;
import com.badlogic.gdx.utils.GdxRuntimeException;

public interface GLErrorListener {
    public static final GLErrorListener LOGGING_LISTENER = new GLErrorListener(){

        @Override
        public void onError(int error) {
            String place = null;
            try {
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                int i = 0;
                while (i < stack.length) {
                    if ("check".equals(stack[i].getMethodName())) {
                        if (i + 1 < stack.length) {
                            StackTraceElement glMethod = stack[i + 1];
                            place = glMethod.getMethodName();
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (place != null) {
                Gdx.app.error("GLProfiler", "Error " + GLInterceptor.resolveErrorNumber(error) + " from " + place);
            } else {
                Gdx.app.error("GLProfiler", "Error " + GLInterceptor.resolveErrorNumber(error) + " at: ", new Exception());
            }
        }
    };
    public static final GLErrorListener THROWING_LISTENER = new GLErrorListener(){

        @Override
        public void onError(int error) {
            throw new GdxRuntimeException("GLProfiler: Got GL error " + GLInterceptor.resolveErrorNumber(error));
        }
    };

    public void onError(int var1);
}

