/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.attachments.AtlasAttachmentLoader;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkinnedMeshAttachment;

public class SkeletonJson {
    private final AttachmentLoader attachmentLoader;
    private float scale = 1.0f;

    public SkeletonJson(TextureAtlas atlas) {
        this.attachmentLoader = new AtlasAttachmentLoader(atlas);
    }

    public SkeletonJson(AttachmentLoader attachmentLoader) {
        this.attachmentLoader = attachmentLoader;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public SkeletonData readSkeletonData(FileHandle file) {
        BoneData boneData;
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        float scale = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        skeletonData.name = file.nameWithoutExtension();
        JsonValue root = new JsonReader().parse(file);
        JsonValue skeletonMap = root.get("skeleton");
        if (skeletonMap != null) {
            skeletonData.hash = skeletonMap.getString("hash", null);
            skeletonData.version = skeletonMap.getString("spine", null);
            skeletonData.width = skeletonMap.getFloat("width", 0.0f);
            skeletonData.height = skeletonMap.getFloat("height", 0.0f);
            skeletonData.imagesPath = skeletonMap.getString("images", null);
        }
        JsonValue boneMap = root.getChild("bones");
        while (boneMap != null) {
            BoneData parent = null;
            String parentName = boneMap.getString("parent", null);
            if (parentName != null && (parent = skeletonData.findBone(parentName)) == null) {
                throw new SerializationException("Parent bone not found: " + parentName);
            }
            boneData = new BoneData(boneMap.getString("name"), parent);
            boneData.length = boneMap.getFloat("length", 0.0f) * scale;
            boneData.x = boneMap.getFloat("x", 0.0f) * scale;
            boneData.y = boneMap.getFloat("y", 0.0f) * scale;
            boneData.rotation = boneMap.getFloat("rotation", 0.0f);
            boneData.scaleX = boneMap.getFloat("scaleX", 1.0f);
            boneData.scaleY = boneMap.getFloat("scaleY", 1.0f);
            boneData.flipX = boneMap.getBoolean("flipX", false);
            boneData.flipY = boneMap.getBoolean("flipY", false);
            boneData.inheritScale = boneMap.getBoolean("inheritScale", true);
            boneData.inheritRotation = boneMap.getBoolean("inheritRotation", true);
            String color = boneMap.getString("color", null);
            if (color != null) {
                boneData.getColor().set(Color.valueOf(color));
            }
            skeletonData.bones.add(boneData);
            boneMap = boneMap.next;
        }
        JsonValue ikMap = root.getChild("ik");
        while (ikMap != null) {
            IkConstraintData ikConstraintData = new IkConstraintData(ikMap.getString("name"));
            JsonValue boneMap2 = ikMap.getChild("bones");
            while (boneMap2 != null) {
                String boneName = boneMap2.asString();
                BoneData bone = skeletonData.findBone(boneName);
                if (bone == null) {
                    throw new SerializationException("IK bone not found: " + boneName);
                }
                ikConstraintData.bones.add(bone);
                boneMap2 = boneMap2.next;
            }
            String targetName = ikMap.getString("target");
            ikConstraintData.target = skeletonData.findBone(targetName);
            if (ikConstraintData.target == null) {
                throw new SerializationException("Target bone not found: " + targetName);
            }
            ikConstraintData.bendDirection = ikMap.getBoolean("bendPositive", true) ? 1 : -1;
            ikConstraintData.mix = ikMap.getFloat("mix", 1.0f);
            skeletonData.ikConstraints.add(ikConstraintData);
            ikMap = ikMap.next;
        }
        JsonValue slotMap = root.getChild("slots");
        while (slotMap != null) {
            String slotName = slotMap.getString("name");
            String boneName = slotMap.getString("bone");
            boneData = skeletonData.findBone(boneName);
            if (boneData == null) {
                throw new SerializationException("Slot bone not found: " + boneName);
            }
            SlotData slotData = new SlotData(slotName, boneData);
            String color = slotMap.getString("color", null);
            if (color != null) {
                slotData.getColor().set(Color.valueOf(color));
            }
            slotData.attachmentName = slotMap.getString("attachment", null);
            slotData.additiveBlending = slotMap.getBoolean("additive", false);
            skeletonData.slots.add(slotData);
            slotMap = slotMap.next;
        }
        JsonValue skinMap = root.getChild("skins");
        while (skinMap != null) {
            Skin skin = new Skin(skinMap.name);
            JsonValue slotEntry = skinMap.child;
            while (slotEntry != null) {
                int slotIndex = skeletonData.findSlotIndex(slotEntry.name);
                if (slotIndex == -1) {
                    throw new SerializationException("Slot not found: " + slotEntry.name);
                }
                JsonValue entry = slotEntry.child;
                while (entry != null) {
                    Attachment attachment = this.readAttachment(skin, entry.name, entry);
                    if (attachment != null) {
                        skin.addAttachment(slotIndex, entry.name, attachment);
                    }
                    entry = entry.next;
                }
                slotEntry = slotEntry.next;
            }
            skeletonData.skins.add(skin);
            if (skin.name.equals("default")) {
                skeletonData.defaultSkin = skin;
            }
            skinMap = skinMap.next;
        }
        JsonValue eventMap = root.getChild("events");
        while (eventMap != null) {
            EventData eventData = new EventData(eventMap.name);
            eventData.intValue = eventMap.getInt("int", 0);
            eventData.floatValue = eventMap.getFloat("float", 0.0f);
            eventData.stringValue = eventMap.getString("string", null);
            skeletonData.events.add(eventData);
            eventMap = eventMap.next;
        }
        JsonValue animationMap = root.getChild("animations");
        while (animationMap != null) {
            this.readAnimation(animationMap.name, animationMap, skeletonData);
            animationMap = animationMap.next;
        }
        skeletonData.bones.shrink();
        skeletonData.slots.shrink();
        skeletonData.skins.shrink();
        skeletonData.events.shrink();
        skeletonData.animations.shrink();
        skeletonData.ikConstraints.shrink();
        return skeletonData;
    }

    private Attachment readAttachment(Skin skin, String name, JsonValue map) {
        float scale = this.scale;
        name = map.getString("name", name);
        String path = map.getString("path", name);
        switch (AttachmentType.valueOf(map.getString("type", AttachmentType.region.name()))) {
            case region: {
                RegionAttachment region = this.attachmentLoader.newRegionAttachment(skin, name, path);
                if (region == null) {
                    return null;
                }
                region.setPath(path);
                region.setX(map.getFloat("x", 0.0f) * scale);
                region.setY(map.getFloat("y", 0.0f) * scale);
                region.setScaleX(map.getFloat("scaleX", 1.0f));
                region.setScaleY(map.getFloat("scaleY", 1.0f));
                region.setRotation(map.getFloat("rotation", 0.0f));
                region.setWidth(map.getFloat("width") * scale);
                region.setHeight(map.getFloat("height") * scale);
                String color = map.getString("color", null);
                if (color != null) {
                    region.getColor().set(Color.valueOf(color));
                }
                region.updateOffset();
                return region;
            }
            case boundingbox: {
                BoundingBoxAttachment box = this.attachmentLoader.newBoundingBoxAttachment(skin, name);
                if (box == null) {
                    return null;
                }
                float[] vertices = map.require("vertices").asFloatArray();
                if (scale != 1.0f) {
                    int i = 0;
                    int n = vertices.length;
                    while (i < n) {
                        int n2 = i++;
                        vertices[n2] = vertices[n2] * scale;
                    }
                }
                box.setVertices(vertices);
                return box;
            }
            case mesh: {
                MeshAttachment mesh = this.attachmentLoader.newMeshAttachment(skin, name, path);
                if (mesh == null) {
                    return null;
                }
                mesh.setPath(path);
                float[] vertices = map.require("vertices").asFloatArray();
                if (scale != 1.0f) {
                    int i = 0;
                    int n = vertices.length;
                    while (i < n) {
                        int n3 = i++;
                        vertices[n3] = vertices[n3] * scale;
                    }
                }
                mesh.setVertices(vertices);
                mesh.setTriangles(map.require("triangles").asShortArray());
                mesh.setRegionUVs(map.require("uvs").asFloatArray());
                mesh.updateUVs();
                String color = map.getString("color", null);
                if (color != null) {
                    mesh.getColor().set(Color.valueOf(color));
                }
                if (map.has("hull")) {
                    mesh.setHullLength(map.require("hull").asInt() * 2);
                }
                if (map.has("edges")) {
                    mesh.setEdges(map.require("edges").asIntArray());
                }
                mesh.setWidth(map.getFloat("width", 0.0f) * scale);
                mesh.setHeight(map.getFloat("height", 0.0f) * scale);
                return mesh;
            }
            case skinnedmesh: {
                SkinnedMeshAttachment mesh = this.attachmentLoader.newSkinnedMeshAttachment(skin, name, path);
                if (mesh == null) {
                    return null;
                }
                mesh.setPath(path);
                float[] uvs = map.require("uvs").asFloatArray();
                float[] vertices = map.require("vertices").asFloatArray();
                FloatArray weights = new FloatArray(uvs.length * 3 * 3);
                IntArray bones = new IntArray(uvs.length * 3);
                int i = 0;
                int n = vertices.length;
                while (i < n) {
                    int boneCount = (int)vertices[i++];
                    bones.add(boneCount);
                    int nn = i + boneCount * 4;
                    while (i < nn) {
                        bones.add((int)vertices[i]);
                        weights.add(vertices[i + 1] * scale);
                        weights.add(vertices[i + 2] * scale);
                        weights.add(vertices[i + 3]);
                        i += 4;
                    }
                }
                mesh.setBones(bones.toArray());
                mesh.setWeights(weights.toArray());
                mesh.setTriangles(map.require("triangles").asShortArray());
                mesh.setRegionUVs(uvs);
                mesh.updateUVs();
                String color = map.getString("color", null);
                if (color != null) {
                    mesh.getColor().set(Color.valueOf(color));
                }
                if (map.has("hull")) {
                    mesh.setHullLength(map.require("hull").asInt() * 2);
                }
                if (map.has("edges")) {
                    mesh.setEdges(map.require("edges").asIntArray());
                }
                mesh.setWidth(map.getFloat("width", 0.0f) * scale);
                mesh.setHeight(map.getFloat("height", 0.0f) * scale);
                return mesh;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void readAnimation(String name, JsonValue map, SkeletonData skeletonData) {
        block49: {
            scale = this.scale;
            timelines = new Array<Animation.Timeline>();
            duration = 0.0f;
            slotMap = map.getChild("slots");
            while (slotMap != null) {
                slotIndex = skeletonData.findSlotIndex(slotMap.name);
                if (slotIndex == -1) {
                    throw new SerializationException("Slot not found: " + slotMap.name);
                }
                timelineMap = slotMap.child;
                while (timelineMap != null) {
                    timelineName = timelineMap.name;
                    if (timelineName.equals("color")) {
                        timeline = new Animation.ColorTimeline(timelineMap.size);
                        timeline.slotIndex = slotIndex;
                        frameIndex = 0;
                        valueMap = timelineMap.child;
                        while (valueMap != null) {
                            color = Color.valueOf(valueMap.getString("color"));
                            timeline.setFrame(frameIndex, valueMap.getFloat("time"), color.r, color.g, color.b, color.a);
                            this.readCurve((Animation.CurveTimeline)timeline, frameIndex, valueMap);
                            ++frameIndex;
                            valueMap = valueMap.next;
                        }
                        timelines.add(timeline);
                        duration = Math.max(duration, timeline.getFrames()[timeline.getFrameCount() * 5 - 5]);
                    } else if (timelineName.equals("attachment")) {
                        timeline = new Animation.AttachmentTimeline(timelineMap.size);
                        timeline.slotIndex = slotIndex;
                        frameIndex = 0;
                        valueMap = timelineMap.child;
                        while (valueMap != null) {
                            timeline.setFrame(frameIndex++, valueMap.getFloat("time"), valueMap.getString("name"));
                            valueMap = valueMap.next;
                        }
                        timelines.add(timeline);
                        duration = Math.max(duration, timeline.getFrames()[timeline.getFrameCount() - 1]);
                    } else {
                        throw new RuntimeException("Invalid timeline type for a slot: " + timelineName + " (" + slotMap.name + ")");
                    }
                    timelineMap = timelineMap.next;
                }
                slotMap = slotMap.next;
            }
            boneMap = map.getChild("bones");
            while (boneMap != null) {
                boneIndex = skeletonData.findBoneIndex(boneMap.name);
                if (boneIndex == -1) {
                    throw new SerializationException("Bone not found: " + boneMap.name);
                }
                timelineMap = boneMap.child;
                while (timelineMap != null) {
                    timelineName = timelineMap.name;
                    if (timelineName.equals("rotate")) {
                        timeline = new Animation.RotateTimeline(timelineMap.size);
                        timeline.boneIndex = boneIndex;
                        frameIndex = 0;
                        valueMap = timelineMap.child;
                        while (valueMap != null) {
                            timeline.setFrame(frameIndex, valueMap.getFloat("time"), valueMap.getFloat("angle"));
                            this.readCurve(timeline, frameIndex, valueMap);
                            ++frameIndex;
                            valueMap = valueMap.next;
                        }
                        timelines.add(timeline);
                        duration = Math.max(duration, timeline.getFrames()[timeline.getFrameCount() * 2 - 2]);
                    } else if (timelineName.equals("translate") || timelineName.equals("scale")) {
                        timelineScale = 1.0f;
                        if (timelineName.equals("scale")) {
                            timeline = new Animation.ScaleTimeline(timelineMap.size);
                        } else {
                            timeline = new Animation.TranslateTimeline(timelineMap.size);
                            timelineScale = scale;
                        }
                        timeline.boneIndex = boneIndex;
                        frameIndex = 0;
                        valueMap = timelineMap.child;
                        while (valueMap != null) {
                            x = valueMap.getFloat("x", 0.0f);
                            y = valueMap.getFloat("y", 0.0f);
                            timeline.setFrame(frameIndex, valueMap.getFloat("time"), x * timelineScale, y * timelineScale);
                            this.readCurve(timeline, frameIndex, valueMap);
                            ++frameIndex;
                            valueMap = valueMap.next;
                        }
                        timelines.add(timeline);
                        duration = Math.max(duration, timeline.getFrames()[timeline.getFrameCount() * 3 - 3]);
                    } else if (timelineName.equals("flipX") || timelineName.equals("flipY")) {
                        x = timelineName.equals("flipX");
                        timeline = x != false ? new Animation.FlipXTimeline(timelineMap.size) : new Animation.FlipYTimeline(timelineMap.size);
                        timeline.boneIndex = boneIndex;
                        field = x != false ? "x" : "y";
                        frameIndex = 0;
                        valueMap = timelineMap.child;
                        while (valueMap != null) {
                            timeline.setFrame(frameIndex, valueMap.getFloat("time"), valueMap.getBoolean(field, false));
                            ++frameIndex;
                            valueMap = valueMap.next;
                        }
                        timelines.add(timeline);
                        duration = Math.max(duration, timeline.getFrames()[timeline.getFrameCount() * 2 - 2]);
                    } else {
                        throw new RuntimeException("Invalid timeline type for a bone: " + timelineName + " (" + boneMap.name + ")");
                    }
                    timelineMap = timelineMap.next;
                }
                boneMap = boneMap.next;
            }
            ikMap = map.getChild("ik");
            while (ikMap != null) {
                ikConstraint = skeletonData.findIkConstraint(ikMap.name);
                timeline = new Animation.IkConstraintTimeline(ikMap.size);
                timeline.ikConstraintIndex = skeletonData.getIkConstraints().indexOf(ikConstraint, true);
                frameIndex = 0;
                valueMap = ikMap.child;
                while (valueMap != null) {
                    timeline.setFrame(frameIndex, valueMap.getFloat("time"), valueMap.getFloat("mix"), valueMap.getBoolean("bendPositive") != false ? 1 : -1);
                    this.readCurve(timeline, frameIndex, valueMap);
                    ++frameIndex;
                    valueMap = valueMap.next;
                }
                timelines.add(timeline);
                duration = Math.max(duration, timeline.getFrames()[timeline.getFrameCount() * 3 - 3]);
                ikMap = ikMap.next;
            }
            ffdMap = map.getChild("ffd");
            while (ffdMap != null) {
                skin = skeletonData.findSkin(ffdMap.name);
                if (skin == null) {
                    throw new SerializationException("Skin not found: " + ffdMap.name);
                }
                slotMap = ffdMap.child;
                while (slotMap != null) {
                    slotIndex = skeletonData.findSlotIndex(slotMap.name);
                    if (slotIndex == -1) {
                        throw new SerializationException("Slot not found: " + slotMap.name);
                    }
                    meshMap = slotMap.child;
                    while (meshMap != null) {
                        timeline = new Animation.FfdTimeline(meshMap.size);
                        attachment = skin.getAttachment(slotIndex, meshMap.name);
                        if (attachment == null) {
                            throw new SerializationException("FFD attachment not found: " + meshMap.name);
                        }
                        timeline.slotIndex = slotIndex;
                        timeline.attachment = attachment;
                        vertexCount = attachment instanceof MeshAttachment != false ? ((MeshAttachment)attachment).getVertices().length : ((SkinnedMeshAttachment)attachment).getWeights().length / 3 * 2;
                        frameIndex = 0;
                        valueMap = meshMap.child;
                        while (valueMap != null) {
                            verticesValue = valueMap.get("vertices");
                            if (verticesValue == null) {
                                vertices = attachment instanceof MeshAttachment ? ((MeshAttachment)attachment).getVertices() : new float[vertexCount];
                            } else {
                                vertices = new float[vertexCount];
                                start = valueMap.getInt("offset", 0);
                                System.arraycopy(verticesValue.asFloatArray(), 0, vertices, start, verticesValue.size);
                                if (scale != 1.0f) {
                                    i = start;
                                    n = i + verticesValue.size;
                                    while (i < n) {
                                        v0 = i++;
                                        vertices[v0] = vertices[v0] * scale;
                                    }
                                }
                                if (attachment instanceof MeshAttachment) {
                                    meshVertices = ((MeshAttachment)attachment).getVertices();
                                    i = 0;
                                    while (i < vertexCount) {
                                        v1 = i;
                                        vertices[v1] = vertices[v1] + meshVertices[i];
                                        ++i;
                                    }
                                }
                            }
                            timeline.setFrame(frameIndex, valueMap.getFloat("time"), vertices);
                            this.readCurve(timeline, frameIndex, valueMap);
                            ++frameIndex;
                            valueMap = valueMap.next;
                        }
                        timelines.add(timeline);
                        duration = Math.max(duration, timeline.getFrames()[timeline.getFrameCount() - 1]);
                        meshMap = meshMap.next;
                    }
                    slotMap = slotMap.next;
                }
                ffdMap = ffdMap.next;
            }
            drawOrdersMap = map.get("drawOrder");
            if (drawOrdersMap == null) {
                drawOrdersMap = map.get("draworder");
            }
            if (drawOrdersMap == null) break block49;
            timeline = new Animation.DrawOrderTimeline(drawOrdersMap.size);
            slotCount = skeletonData.slots.size;
            frameIndex = 0;
            drawOrderMap = drawOrdersMap.child;
            while (drawOrderMap != null) {
                block50: {
                    drawOrder = null;
                    offsets = drawOrderMap.get("offsets");
                    if (offsets == null) break block50;
                    drawOrder = new int[slotCount];
                    i = slotCount - 1;
                    while (i >= 0) {
                        drawOrder[i] = -1;
                        --i;
                    }
                    unchanged = new int[slotCount - offsets.size];
                    originalIndex = 0;
                    unchangedIndex = 0;
                    offsetMap = offsets.child;
                    while (offsetMap != null) {
                        slotIndex = skeletonData.findSlotIndex(offsetMap.getString("slot"));
                        if (slotIndex != -1) ** GOTO lbl208
                        throw new SerializationException("Slot not found: " + offsetMap.getString("slot"));
lbl-1000:
                        // 1 sources

                        {
                            unchanged[unchangedIndex++] = originalIndex++;
lbl208:
                            // 2 sources

                            ** while (originalIndex != slotIndex)
                        }
lbl209:
                        // 1 sources

                        drawOrder[originalIndex + offsetMap.getInt((String)"offset")] = originalIndex++;
                        offsetMap = offsetMap.next;
                    }
                    while (originalIndex < slotCount) {
                        unchanged[unchangedIndex++] = originalIndex++;
                    }
                    i = slotCount - 1;
                    while (i >= 0) {
                        if (drawOrder[i] == -1) {
                            drawOrder[i] = unchanged[--unchangedIndex];
                        }
                        --i;
                    }
                }
                timeline.setFrame(frameIndex++, drawOrderMap.getFloat("time"), drawOrder);
                drawOrderMap = drawOrderMap.next;
            }
            timelines.add(timeline);
            duration = Math.max(duration, timeline.getFrames()[timeline.getFrameCount() - 1]);
        }
        if ((eventsMap = map.get("events")) != null) {
            timeline = new Animation.EventTimeline(eventsMap.size);
            frameIndex = 0;
            eventMap = eventsMap.child;
            while (eventMap != null) {
                eventData = skeletonData.findEvent(eventMap.getString("name"));
                if (eventData == null) {
                    throw new SerializationException("Event not found: " + eventMap.getString("name"));
                }
                event = new Event(eventData);
                event.intValue = eventMap.getInt("int", eventData.getInt());
                event.floatValue = eventMap.getFloat("float", eventData.getFloat());
                event.stringValue = eventMap.getString("string", eventData.getString());
                timeline.setFrame(frameIndex++, eventMap.getFloat("time"), event);
                eventMap = eventMap.next;
            }
            timelines.add(timeline);
            duration = Math.max(duration, timeline.getFrames()[timeline.getFrameCount() - 1]);
        }
        timelines.shrink();
        skeletonData.animations.add(new Animation(name, timelines, duration));
    }

    void readCurve(Animation.CurveTimeline timeline, int frameIndex, JsonValue valueMap) {
        JsonValue curve = valueMap.get("curve");
        if (curve == null) {
            return;
        }
        if (curve.isString() && curve.asString().equals("stepped")) {
            timeline.setStepped(frameIndex);
        } else if (curve.isArray()) {
            timeline.setCurve(frameIndex, curve.getFloat(0), curve.getFloat(1), curve.getFloat(2), curve.getFloat(3));
        }
    }
}

