/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;

public class Skin {
    final String name;
    final ObjectMap<Key, Attachment> attachments = new ObjectMap();
    private final Key lookup = new Key();
    final Pool<Key> keyPool = new Pool(64){

        protected Object newObject() {
            return new Key();
        }
    };

    public Skin(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = string;
    }

    public void addAttachment(int n, String string, Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment cannot be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("slotIndex must be >= 0.");
        }
        Key key = this.keyPool.obtain();
        key.set(n, string);
        this.attachments.put(key, attachment);
    }

    public void addAttachments(Skin skin) {
        for (ObjectMap.Entry entry : skin.attachments.entries()) {
            this.addAttachment(((Key)entry.key).slotIndex, ((Key)entry.key).name, (Attachment)entry.value);
        }
    }

    public Attachment getAttachment(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("slotIndex must be >= 0.");
        }
        this.lookup.set(n, string);
        return this.attachments.get(this.lookup);
    }

    public void removeAttachment(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("slotIndex must be >= 0.");
        }
        Key key = this.keyPool.obtain();
        key.set(n, string);
        this.attachments.remove(key);
        this.keyPool.free(key);
    }

    public void findNamesForSlot(int n, Array<String> array) {
        if (array == null) {
            throw new IllegalArgumentException("names cannot be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("slotIndex must be >= 0.");
        }
        for (Key key : this.attachments.keys()) {
            if (key.slotIndex != n) continue;
            array.add(key.name);
        }
    }

    public void findAttachmentsForSlot(int n, Array<Attachment> array) {
        if (array == null) {
            throw new IllegalArgumentException("attachments cannot be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("slotIndex must be >= 0.");
        }
        for (ObjectMap.Entry entry : this.attachments.entries()) {
            if (((Key)entry.key).slotIndex != n) continue;
            array.add((Attachment)entry.value);
        }
    }

    public void getAttachments(Array<Attachment> array) {
        if (array == null) {
            throw new IllegalArgumentException("attachments cannot be null.");
        }
        for (Attachment attachment : this.attachments.values()) {
            array.add(attachment);
        }
    }

    public void clear() {
        for (Key key : this.attachments.keys()) {
            this.keyPool.free(key);
        }
        this.attachments.clear(1024);
    }

    public int size() {
        return this.attachments.size;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    void attachAll(Skeleton skeleton, Skin skin) {
        for (ObjectMap.Entry entry : skin.attachments.entries()) {
            Attachment attachment;
            int n = ((Key)entry.key).slotIndex;
            Slot slot = skeleton.slots.get(n);
            if (slot.attachment != entry.value || (attachment = this.getAttachment(n, ((Key)entry.key).name)) == null) continue;
            slot.setAttachment(attachment);
        }
    }

    static class Key {
        int slotIndex;
        String name;
        int hashCode;

        Key() {
        }

        public void set(int n, String string) {
            if (string == null) {
                throw new IllegalArgumentException("name cannot be null.");
            }
            this.slotIndex = n;
            this.name = string;
            this.hashCode = string.hashCode() + n * 37;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            Key key = (Key)object;
            if (this.slotIndex != key.slotIndex) {
                return false;
            }
            return this.name.equals(key.name);
        }

        public String toString() {
            return this.slotIndex + ":" + this.name;
        }
    }
}

