/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.OrderedMap;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;

public class Skin {
    final String name;
    final OrderedMap<SkinEntry, SkinEntry> attachments = new OrderedMap();
    final Array<BoneData> bones = new Array();
    final Array<ConstraintData> constraints = new Array();
    private final SkinEntry lookup = new SkinEntry();

    public Skin(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = string;
        this.attachments.orderedKeys().ordered = false;
    }

    public void setAttachment(int n, String string, Attachment attachment) {
        if (n < 0) {
            throw new IllegalArgumentException("slotIndex must be >= 0.");
        }
        if (attachment == null) {
            throw new IllegalArgumentException("attachment cannot be null.");
        }
        SkinEntry skinEntry = new SkinEntry(n, string, attachment);
        SkinEntry skinEntry2 = this.attachments.put(skinEntry, skinEntry);
        if (skinEntry2 != null) {
            skinEntry2.attachment = attachment;
        }
    }

    public Attachment getAttachment(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("slotIndex must be >= 0.");
        }
        this.lookup.set(n, string);
        SkinEntry skinEntry = (SkinEntry)this.attachments.get(this.lookup);
        return skinEntry != null ? skinEntry.attachment : null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    void attachAll(Skeleton skeleton, Skin skin) {
        for (SkinEntry skinEntry : skin.attachments.keys()) {
            Attachment attachment;
            int n = skinEntry.slotIndex;
            Slot slot = skeleton.slots.get(n);
            if (slot.attachment != skinEntry.attachment || (attachment = this.getAttachment(n, skinEntry.name)) == null) continue;
            slot.setAttachment(attachment);
        }
    }

    public static class SkinEntry {
        int slotIndex;
        String name;
        Attachment attachment;
        private int hashCode;

        SkinEntry() {
            this.set(0, "");
        }

        SkinEntry(int n, String string, Attachment attachment) {
            this.set(n, string);
            this.attachment = attachment;
        }

        void set(int n, String string) {
            if (string == null) {
                throw new IllegalArgumentException("name cannot be null.");
            }
            this.slotIndex = n;
            this.name = string;
            this.hashCode = string.hashCode() + n * 37;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public Attachment getAttachment() {
            return this.attachment;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            SkinEntry skinEntry = (SkinEntry)object;
            if (this.slotIndex != skinEntry.slotIndex) {
                return false;
            }
            return this.name.equals(skinEntry.name);
        }

        public String toString() {
            return this.slotIndex + ":" + this.name;
        }
    }
}

