/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;

public class Container<T extends Actor>
extends WidgetGroup {
    private T actor;
    private Value minWidth;
    private Value minHeight;
    private Value prefWidth;
    private Value prefHeight;
    private Value maxWidth;
    private Value maxHeight;
    private Value padTop;
    private Value padLeft;
    private Value padBottom;
    private Value padRight;
    private float fillX;
    private float fillY;
    private int align;
    private Drawable background;
    private boolean clip;
    private boolean round;

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(batch, this.computeTransform());
            this.drawBackground(batch, parentAlpha, 0.0f, 0.0f);
            if (this.clip) {
                batch.flush();
                float padLeft = this.padLeft.get(this);
                float padBottom = this.padBottom.get(this);
                if (this.clipBegin(padLeft, padBottom, this.getWidth() - padLeft - this.padRight.get(this), this.getHeight() - padBottom - this.padTop.get(this))) {
                    this.drawChildren(batch, parentAlpha);
                    batch.flush();
                    this.clipEnd();
                }
            } else {
                this.drawChildren(batch, parentAlpha);
            }
            this.resetTransform(batch);
        } else {
            this.drawBackground(batch, parentAlpha, this.getX(), this.getY());
            super.draw(batch, parentAlpha);
        }
    }

    protected void drawBackground(Batch batch, float parentAlpha, float x, float y) {
        if (this.background == null) {
            return;
        }
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        this.background.draw(batch, x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public void layout() {
        float height;
        if (this.actor == null) {
            return;
        }
        float padLeft = this.padLeft.get(this);
        float padBottom = this.padBottom.get(this);
        float containerWidth = this.getWidth() - padLeft - this.padRight.get(this);
        float containerHeight = this.getHeight() - padBottom - this.padTop.get(this);
        float minWidth = this.minWidth.get((Actor)this.actor);
        float minHeight = this.minHeight.get((Actor)this.actor);
        float prefWidth = this.prefWidth.get((Actor)this.actor);
        float prefHeight = this.prefHeight.get((Actor)this.actor);
        float maxWidth = this.maxWidth.get((Actor)this.actor);
        float maxHeight = this.maxHeight.get((Actor)this.actor);
        float width = this.fillX > 0.0f ? containerWidth * this.fillX : Math.min(prefWidth, containerWidth);
        if (width < minWidth) {
            width = minWidth;
        }
        if (maxWidth > 0.0f && width > maxWidth) {
            width = maxWidth;
        }
        if ((height = this.fillY > 0.0f ? containerHeight * this.fillY : Math.min(prefHeight, containerHeight)) < minHeight) {
            height = minHeight;
        }
        if (maxHeight > 0.0f && height > maxHeight) {
            height = maxHeight;
        }
        float x = padLeft;
        if ((this.align & 0x10) != 0) {
            x += containerWidth - width;
        } else if ((this.align & 8) == 0) {
            x += (containerWidth - width) / 2.0f;
        }
        float y = padBottom;
        if ((this.align & 2) != 0) {
            y += containerHeight - height;
        } else if ((this.align & 4) == 0) {
            y += (containerHeight - height) / 2.0f;
        }
        if (this.round) {
            x = Math.round(x);
            y = Math.round(y);
            width = Math.round(width);
            height = Math.round(height);
        }
        ((Actor)this.actor).setBounds(x, y, width, height);
        if (this.actor instanceof Layout) {
            ((Layout)this.actor).validate();
        }
    }

    @Override
    public void setCullingArea(Rectangle cullingArea) {
        super.setCullingArea(cullingArea);
        if (this.fillX == 1.0f && this.fillY == 1.0f && this.actor instanceof Cullable) {
            ((Cullable)this.actor).setCullingArea(cullingArea);
        }
    }

    public void setActor(T actor) {
        if (actor == this) {
            throw new IllegalArgumentException("actor cannot be the Container.");
        }
        if (actor == this.actor) {
            return;
        }
        if (this.actor != null) {
            super.removeActor((Actor)this.actor);
        }
        this.actor = actor;
        if (actor != null) {
            super.addActor((Actor)actor);
        }
    }

    public T getActor() {
        return this.actor;
    }

    @Override
    @Deprecated
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use Container#setActor.");
    }

    @Override
    public boolean removeActor(Actor actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (actor != this.actor) {
            return false;
        }
        this.setActor(null);
        return true;
    }

    @Override
    public boolean removeActor(Actor actor, boolean unfocus) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (actor != this.actor) {
            return false;
        }
        this.actor = null;
        return super.removeActor(actor, unfocus);
    }

    @Override
    public Actor removeActorAt(int index, boolean unfocus) {
        Actor actor = super.removeActorAt(index, unfocus);
        if (actor == this.actor) {
            this.actor = null;
        }
        return actor;
    }

    public Container<T> width(Value width) {
        if (width == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        this.minWidth = width;
        this.prefWidth = width;
        this.maxWidth = width;
        return this;
    }

    public Container<T> width(float width) {
        this.width(Value.Fixed.valueOf(width));
        return this;
    }

    @Override
    public float getMinWidth() {
        return this.minWidth.get((Actor)this.actor) + this.padLeft.get(this) + this.padRight.get(this);
    }

    @Override
    public float getMinHeight() {
        return this.minHeight.get((Actor)this.actor) + this.padTop.get(this) + this.padBottom.get(this);
    }

    @Override
    public float getPrefWidth() {
        float v = this.prefWidth.get((Actor)this.actor);
        if (this.background != null) {
            v = Math.max(v, this.background.getMinWidth());
        }
        return Math.max(this.getMinWidth(), v + this.padLeft.get(this) + this.padRight.get(this));
    }

    @Override
    public float getPrefHeight() {
        float v = this.prefHeight.get((Actor)this.actor);
        if (this.background != null) {
            v = Math.max(v, this.background.getMinHeight());
        }
        return Math.max(this.getMinHeight(), v + this.padTop.get(this) + this.padBottom.get(this));
    }

    @Override
    public float getMaxWidth() {
        float v = this.maxWidth.get((Actor)this.actor);
        if (v > 0.0f) {
            v += this.padLeft.get(this) + this.padRight.get(this);
        }
        return v;
    }

    @Override
    public float getMaxHeight() {
        float v = this.maxHeight.get((Actor)this.actor);
        if (v > 0.0f) {
            v += this.padTop.get(this) + this.padBottom.get(this);
        }
        return v;
    }

    @Override
    public Actor hit(float x, float y, boolean touchable) {
        if (this.clip) {
            if (touchable && this.getTouchable() == Touchable.disabled) {
                return null;
            }
            if (x < 0.0f || x >= this.getWidth() || y < 0.0f || y >= this.getHeight()) {
                return null;
            }
        }
        return super.hit(x, y, touchable);
    }

    @Override
    public void drawDebug(ShapeRenderer shapes) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(shapes, this.computeTransform());
            if (this.clip) {
                boolean draw;
                shapes.flush();
                float padLeft = this.padLeft.get(this);
                float padBottom = this.padBottom.get(this);
                boolean bl = draw = this.background == null ? this.clipBegin(0.0f, 0.0f, this.getWidth(), this.getHeight()) : this.clipBegin(padLeft, padBottom, this.getWidth() - padLeft - this.padRight.get(this), this.getHeight() - padBottom - this.padTop.get(this));
                if (draw) {
                    this.drawDebugChildren(shapes);
                    this.clipEnd();
                }
            } else {
                this.drawDebugChildren(shapes);
            }
            this.resetTransform(shapes);
        } else {
            super.drawDebug(shapes);
        }
    }
}

