/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Disposable;

public class ShapeRenderer
implements Disposable {
    private final ImmediateModeRenderer renderer;
    private boolean matrixDirty = false;
    private final Matrix4 projectionMatrix = new Matrix4();
    private final Matrix4 transformMatrix = new Matrix4();
    private final Matrix4 combinedMatrix = new Matrix4();
    private final Vector2 tmp = new Vector2();
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private ShapeType shapeType;
    private boolean autoShapeType;
    private float defaultRectLineWidth = 0.75f;

    public ShapeRenderer() {
        this(5000);
    }

    public ShapeRenderer(int maxVertices) {
        this(maxVertices, null);
    }

    public ShapeRenderer(int maxVertices, ShaderProgram defaultShader) {
        this.renderer = defaultShader == null ? new ImmediateModeRenderer20(maxVertices, false, true, 0) : new ImmediateModeRenderer20(maxVertices, false, true, 0, defaultShader);
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.matrixDirty = true;
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    public void updateMatrices() {
        this.matrixDirty = true;
    }

    public void setProjectionMatrix(Matrix4 matrix) {
        this.projectionMatrix.set(matrix);
        this.matrixDirty = true;
    }

    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public void setTransformMatrix(Matrix4 matrix) {
        this.transformMatrix.set(matrix);
        this.matrixDirty = true;
    }

    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    public void setAutoShapeType(boolean autoShapeType) {
        this.autoShapeType = autoShapeType;
    }

    public void begin() {
        if (!this.autoShapeType) {
            throw new IllegalStateException("autoShapeType must be true to use this method.");
        }
        this.begin(ShapeType.Line);
    }

    public void begin(ShapeType type) {
        if (this.shapeType != null) {
            throw new IllegalStateException("Call end() before beginning a new shape batch.");
        }
        this.shapeType = type;
        if (this.matrixDirty) {
            this.combinedMatrix.set(this.projectionMatrix);
            Matrix4.mul(this.combinedMatrix.val, this.transformMatrix.val);
            this.matrixDirty = false;
        }
        this.renderer.begin(this.combinedMatrix, this.shapeType.getGlType());
    }

    public void set(ShapeType type) {
        if (this.shapeType == type) {
            return;
        }
        if (this.shapeType == null) {
            throw new IllegalStateException("begin must be called first.");
        }
        if (!this.autoShapeType) {
            throw new IllegalStateException("autoShapeType must be enabled.");
        }
        this.end();
        this.begin(type);
    }

    public final void line(float x, float y, float x2, float y2) {
        this.line(x, y, 0.0f, x2, y2, 0.0f, this.color, this.color);
    }

    public void line(float x, float y, float z, float x2, float y2, float z2, Color c1, Color c2) {
        if (this.shapeType == ShapeType.Filled) {
            this.rectLine(x, y, x2, y2, this.defaultRectLineWidth, c1, c2);
            return;
        }
        this.check(ShapeType.Line, null, 2);
        this.renderer.color(c1.r, c1.g, c1.b, c1.a);
        this.renderer.vertex(x, y, z);
        this.renderer.color(c2.r, c2.g, c2.b, c2.a);
        this.renderer.vertex(x2, y2, z2);
    }

    public void curve(float x1, float y1, float cx1, float cy1, float cx2, float cy2, float x2, float y2, int segments) {
        this.check(ShapeType.Line, null, segments * 2 + 2);
        float colorBits = this.color.toFloatBits();
        float subdiv_step = 1.0f / (float)segments;
        float subdiv_step2 = subdiv_step * subdiv_step;
        float subdiv_step3 = subdiv_step * subdiv_step * subdiv_step;
        float pre1 = 3.0f * subdiv_step;
        float pre2 = 3.0f * subdiv_step2;
        float pre4 = 6.0f * subdiv_step2;
        float pre5 = 6.0f * subdiv_step3;
        float tmp1x = x1 - cx1 * 2.0f + cx2;
        float tmp1y = y1 - cy1 * 2.0f + cy2;
        float tmp2x = (cx1 - cx2) * 3.0f - x1 + x2;
        float tmp2y = (cy1 - cy2) * 3.0f - y1 + y2;
        float fx = x1;
        float fy = y1;
        float dfx = (cx1 - x1) * pre1 + tmp1x * pre2 + tmp2x * subdiv_step3;
        float dfy = (cy1 - y1) * pre1 + tmp1y * pre2 + tmp2y * subdiv_step3;
        float ddfx = tmp1x * pre4 + tmp2x * pre5;
        float ddfy = tmp1y * pre4 + tmp2y * pre5;
        float dddfx = tmp2x * pre5;
        float dddfy = tmp2y * pre5;
        while (segments-- > 0) {
            this.renderer.color(colorBits);
            this.renderer.vertex(fx, fy, 0.0f);
            fx += dfx;
            fy += dfy;
            dfx += ddfx;
            dfy += ddfy;
            ddfx += dddfx;
            ddfy += dddfy;
            this.renderer.color(colorBits);
            this.renderer.vertex(fx, fy, 0.0f);
        }
        this.renderer.color(colorBits);
        this.renderer.vertex(fx, fy, 0.0f);
        this.renderer.color(colorBits);
        this.renderer.vertex(x2, y2, 0.0f);
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.check(ShapeType.Line, ShapeType.Filled, 6);
        float colorBits = this.color.toFloatBits();
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(colorBits);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x1, y1, 0.0f);
        } else {
            this.renderer.color(colorBits);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x3, y3, 0.0f);
        }
    }

    public void rect(float x, float y, float width, float height) {
        this.check(ShapeType.Line, ShapeType.Filled, 8);
        float colorBits = this.color.toFloatBits();
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(colorBits);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x + width, y, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x + width, y, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x, y + height, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x, y + height, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x, y, 0.0f);
        } else {
            this.renderer.color(colorBits);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x + width, y, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x + width, y + height, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x, y + height, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x, y, 0.0f);
        }
    }

    public void rect(float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float degrees) {
        this.rect(x, y, originX, originY, width, height, scaleX, scaleY, degrees, this.color, this.color, this.color, this.color);
    }

    public void rect(float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float degrees, Color col1, Color col2, Color col3, Color col4) {
        this.check(ShapeType.Line, ShapeType.Filled, 8);
        float cos = MathUtils.cosDeg(degrees);
        float sin = MathUtils.sinDeg(degrees);
        float fx = -originX;
        float fy = -originY;
        float fx2 = width - originX;
        float fy2 = height - originY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            fx *= scaleX;
            fy *= scaleY;
            fx2 *= scaleX;
            fy2 *= scaleY;
        }
        float worldOriginX = x + originX;
        float worldOriginY = y + originY;
        float x1 = cos * fx - sin * fy + worldOriginX;
        float y1 = sin * fx + cos * fy + worldOriginY;
        float x2 = cos * fx2 - sin * fy + worldOriginX;
        float y2 = sin * fx2 + cos * fy + worldOriginY;
        float x3 = cos * fx2 - sin * fy2 + worldOriginX;
        float y3 = sin * fx2 + cos * fy2 + worldOriginY;
        float x4 = x1 + (x3 - x2);
        float y4 = y3 - (y2 - y1);
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(col4.r, col4.g, col4.b, col4.a);
            this.renderer.vertex(x4, y4, 0.0f);
            this.renderer.color(col4.r, col4.g, col4.b, col4.a);
            this.renderer.vertex(x4, y4, 0.0f);
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x1, y1, 0.0f);
        } else {
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(col2.r, col2.g, col2.b, col2.a);
            this.renderer.vertex(x2, y2, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(col3.r, col3.g, col3.b, col3.a);
            this.renderer.vertex(x3, y3, 0.0f);
            this.renderer.color(col4.r, col4.g, col4.b, col4.a);
            this.renderer.vertex(x4, y4, 0.0f);
            this.renderer.color(col1.r, col1.g, col1.b, col1.a);
            this.renderer.vertex(x1, y1, 0.0f);
        }
    }

    public void rectLine(float x1, float y1, float x2, float y2, float width) {
        this.check(ShapeType.Line, ShapeType.Filled, 8);
        float colorBits = this.color.toFloatBits();
        Vector2 t = this.tmp.set(y2 - y1, x1 - x2).nor();
        float tx = t.x * (width *= 0.5f);
        float ty = t.y * width;
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(colorBits);
            this.renderer.vertex(x1 + tx, y1 + ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x1 - tx, y1 - ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2 + tx, y2 + ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2 - tx, y2 - ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2 + tx, y2 + ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x1 + tx, y1 + ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2 - tx, y2 - ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x1 - tx, y1 - ty, 0.0f);
        } else {
            this.renderer.color(colorBits);
            this.renderer.vertex(x1 + tx, y1 + ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x1 - tx, y1 - ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2 + tx, y2 + ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2 - tx, y2 - ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2 + tx, y2 + ty, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x1 - tx, y1 - ty, 0.0f);
        }
    }

    public void rectLine(float x1, float y1, float x2, float y2, float width, Color c1, Color c2) {
        this.check(ShapeType.Line, ShapeType.Filled, 8);
        float col1Bits = c1.toFloatBits();
        float col2Bits = c2.toFloatBits();
        Vector2 t = this.tmp.set(y2 - y1, x1 - x2).nor();
        float tx = t.x * (width *= 0.5f);
        float ty = t.y * width;
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(col1Bits);
            this.renderer.vertex(x1 + tx, y1 + ty, 0.0f);
            this.renderer.color(col1Bits);
            this.renderer.vertex(x1 - tx, y1 - ty, 0.0f);
            this.renderer.color(col2Bits);
            this.renderer.vertex(x2 + tx, y2 + ty, 0.0f);
            this.renderer.color(col2Bits);
            this.renderer.vertex(x2 - tx, y2 - ty, 0.0f);
            this.renderer.color(col2Bits);
            this.renderer.vertex(x2 + tx, y2 + ty, 0.0f);
            this.renderer.color(col1Bits);
            this.renderer.vertex(x1 + tx, y1 + ty, 0.0f);
            this.renderer.color(col2Bits);
            this.renderer.vertex(x2 - tx, y2 - ty, 0.0f);
            this.renderer.color(col1Bits);
            this.renderer.vertex(x1 - tx, y1 - ty, 0.0f);
        } else {
            this.renderer.color(col1Bits);
            this.renderer.vertex(x1 + tx, y1 + ty, 0.0f);
            this.renderer.color(col1Bits);
            this.renderer.vertex(x1 - tx, y1 - ty, 0.0f);
            this.renderer.color(col2Bits);
            this.renderer.vertex(x2 + tx, y2 + ty, 0.0f);
            this.renderer.color(col2Bits);
            this.renderer.vertex(x2 - tx, y2 - ty, 0.0f);
            this.renderer.color(col2Bits);
            this.renderer.vertex(x2 + tx, y2 + ty, 0.0f);
            this.renderer.color(col1Bits);
            this.renderer.vertex(x1 - tx, y1 - ty, 0.0f);
        }
    }

    public void rectLine(Vector2 p1, Vector2 p2, float width) {
        this.rectLine(p1.x, p1.y, p2.x, p2.y, width);
    }

    public void x(float x, float y, float size) {
        this.line(x - size, y - size, x + size, y + size);
        this.line(x - size, y + size, x + size, y - size);
    }

    public void circle(float x, float y, float radius, int segments) {
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        float colorBits = this.color.toFloatBits();
        float angle = (float)Math.PI * 2 / (float)segments;
        float cos = MathUtils.cos(angle);
        float sin = MathUtils.sin(angle);
        float cx = radius;
        float cy = 0.0f;
        if (this.shapeType == ShapeType.Line) {
            this.check(ShapeType.Line, ShapeType.Filled, segments * 2 + 2);
            for (int i = 0; i < segments; ++i) {
                this.renderer.color(colorBits);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
                float temp = cx;
                cx = cos * cx - sin * cy;
                cy = sin * temp + cos * cy;
                this.renderer.color(colorBits);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
            }
            this.renderer.color(colorBits);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
        } else {
            this.check(ShapeType.Line, ShapeType.Filled, segments * 3 + 3);
            --segments;
            for (int i = 0; i < segments; ++i) {
                this.renderer.color(colorBits);
                this.renderer.vertex(x, y, 0.0f);
                this.renderer.color(colorBits);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
                float temp = cx;
                cx = cos * cx - sin * cy;
                cy = sin * temp + cos * cy;
                this.renderer.color(colorBits);
                this.renderer.vertex(x + cx, y + cy, 0.0f);
            }
            this.renderer.color(colorBits);
            this.renderer.vertex(x, y, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x + cx, y + cy, 0.0f);
        }
        float temp = cx;
        cx = radius;
        cy = 0.0f;
        this.renderer.color(colorBits);
        this.renderer.vertex(x + cx, y + cy, 0.0f);
    }

    public void polygon(float[] vertices, int offset, int count) {
        if (count < 6) {
            throw new IllegalArgumentException("Polygons must contain at least 3 points.");
        }
        if (count % 2 != 0) {
            throw new IllegalArgumentException("Polygons must have an even number of vertices.");
        }
        this.check(ShapeType.Line, null, count);
        float colorBits = this.color.toFloatBits();
        float firstX = vertices[0];
        float firstY = vertices[1];
        int n = offset + count;
        for (int i = offset; i < n; i += 2) {
            float y2;
            float x2;
            float x1 = vertices[i];
            float y1 = vertices[i + 1];
            if (i + 2 >= count) {
                x2 = firstX;
                y2 = firstY;
            } else {
                x2 = vertices[i + 2];
                y2 = vertices[i + 3];
            }
            this.renderer.color(colorBits);
            this.renderer.vertex(x1, y1, 0.0f);
            this.renderer.color(colorBits);
            this.renderer.vertex(x2, y2, 0.0f);
        }
    }

    protected final void check(ShapeType preferred, ShapeType other, int newVertices) {
        if (this.shapeType == null) {
            throw new IllegalStateException("begin must be called first.");
        }
        if (this.shapeType != preferred && this.shapeType != other) {
            if (!this.autoShapeType) {
                if (other == null) {
                    throw new IllegalStateException("Must call begin(ShapeType." + preferred + ").");
                }
                throw new IllegalStateException("Must call begin(ShapeType." + preferred + ") or begin(ShapeType." + other + ").");
            }
            this.end();
            this.begin(preferred);
        } else if (this.matrixDirty) {
            ShapeType type = this.shapeType;
            this.end();
            this.begin(type);
        } else if (this.renderer.getMaxVertices() - this.renderer.getNumVertices() < newVertices) {
            ShapeType type = this.shapeType;
            this.end();
            this.begin(type);
        }
    }

    public void end() {
        this.renderer.end();
        this.shapeType = null;
    }

    public void flush() {
        ShapeType type = this.shapeType;
        if (type == null) {
            return;
        }
        this.end();
        this.begin(type);
    }

    public boolean isDrawing() {
        return this.shapeType != null;
    }

    @Override
    public void dispose() {
        this.renderer.dispose();
    }

    public static enum ShapeType {
        Point(0),
        Line(1),
        Filled(4);

        private final int glType;

        private ShapeType(int glType) {
            this.glType = glType;
        }

        public int getGlType() {
            return this.glType;
        }
    }
}

