/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.Sequence;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class SkeletonJson
extends SkeletonLoader {
    private final Array<LinkedMesh> linkedMeshes = new Array();

    public SkeletonJson(TextureAtlas textureAtlas) {
        super(textureAtlas);
    }

    @Override
    public SkeletonData readSkeletonData(FileHandle fileHandle) {
        if (fileHandle == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        SkeletonData skeletonData = this.readSkeletonData(new JsonReader().parse(fileHandle));
        skeletonData.name = fileHandle.nameWithoutExtension();
        return skeletonData;
    }

    public SkeletonData readSkeletonData(JsonValue jsonValue) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (jsonValue == null) {
            throw new IllegalArgumentException("root cannot be null.");
        }
        float f = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        JsonValue jsonValue2 = jsonValue.get("skeleton");
        if (jsonValue2 != null) {
            skeletonData.hash = jsonValue2.getString("hash", null);
            skeletonData.version = jsonValue2.getString("spine", null);
            skeletonData.x = jsonValue2.getFloat("x", 0.0f);
            skeletonData.y = jsonValue2.getFloat("y", 0.0f);
            skeletonData.width = jsonValue2.getFloat("width", 0.0f);
            skeletonData.height = jsonValue2.getFloat("height", 0.0f);
            skeletonData.referenceScale = jsonValue2.getFloat("referenceScale", 100.0f) * f;
            skeletonData.fps = jsonValue2.getFloat("fps", 30.0f);
            skeletonData.imagesPath = jsonValue2.getString("images", null);
            skeletonData.audioPath = jsonValue2.getString("audio", null);
        }
        Object object6 = jsonValue.getChild("bones");
        while (object6 != null) {
            object5 = null;
            object4 = ((JsonValue)object6).getString("parent", null);
            if (object4 != null && (object5 = skeletonData.findBone((String)object4)) == null) {
                throw new SerializationException("Parent bone not found: " + (String)object4);
            }
            object3 = new BoneData(skeletonData.bones.size, ((JsonValue)object6).getString("name"), (BoneData)object5);
            ((BoneData)object3).length = ((JsonValue)object6).getFloat("length", 0.0f) * f;
            ((BoneData)object3).x = ((JsonValue)object6).getFloat("x", 0.0f) * f;
            ((BoneData)object3).y = ((JsonValue)object6).getFloat("y", 0.0f) * f;
            ((BoneData)object3).rotation = ((JsonValue)object6).getFloat("rotation", 0.0f);
            ((BoneData)object3).scaleX = ((JsonValue)object6).getFloat("scaleX", 1.0f);
            ((BoneData)object3).scaleY = ((JsonValue)object6).getFloat("scaleY", 1.0f);
            ((BoneData)object3).shearX = ((JsonValue)object6).getFloat("shearX", 0.0f);
            ((BoneData)object3).shearY = ((JsonValue)object6).getFloat("shearY", 0.0f);
            ((BoneData)object3).inherit = BoneData.Inherit.valueOf(((JsonValue)object6).getString("inherit", BoneData.Inherit.normal.name()));
            ((BoneData)object3).skinRequired = ((JsonValue)object6).getBoolean("skin", false);
            object2 = ((JsonValue)object6).getString("color", null);
            if (object2 != null) {
                Color.valueOf((String)object2, ((BoneData)object3).getColor());
            }
            ((BoneData)object3).icon = ((JsonValue)object6).getString("icon", null);
            ((BoneData)object3).visible = ((JsonValue)object6).getBoolean("visible", true);
            skeletonData.bones.add((BoneData)object3);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("slots");
        while (object6 != null) {
            String string;
            object5 = ((JsonValue)object6).getString("name");
            object4 = ((JsonValue)object6).getString("bone");
            object3 = skeletonData.findBone((String)object4);
            if (object3 == null) {
                throw new SerializationException("Slot bone not found: " + (String)object4);
            }
            object2 = new SlotData(skeletonData.slots.size, (String)object5, (BoneData)object3);
            object = ((JsonValue)object6).getString("color", null);
            if (object != null) {
                Color.valueOf((String)object, ((SlotData)object2).getColor());
            }
            if ((string = ((JsonValue)object6).getString("dark", null)) != null) {
                ((SlotData)object2).setDarkColor(Color.valueOf(string));
            }
            ((SlotData)object2).attachmentName = ((JsonValue)object6).getString("attachment", null);
            ((SlotData)object2).blendMode = BlendMode.valueOf(((JsonValue)object6).getString("blend", BlendMode.normal.name()));
            ((SlotData)object2).visible = ((JsonValue)object6).getBoolean("visible", true);
            skeletonData.slots.add((SlotData)object2);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("ik");
        while (object6 != null) {
            object5 = new IkConstraintData(((JsonValue)object6).getString("name"));
            ((IkConstraintData)object5).order = ((JsonValue)object6).getInt("order", 0);
            ((IkConstraintData)object5).skinRequired = ((JsonValue)object6).getBoolean("skin", false);
            object4 = ((JsonValue)object6).getChild("bones");
            while (object4 != null) {
                object3 = skeletonData.findBone(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("IK bone not found: " + (JsonValue)object4);
                }
                ((IkConstraintData)object5).bones.add((BoneData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getString("target");
            ((IkConstraintData)object5).target = skeletonData.findBone((String)object4);
            if (((IkConstraintData)object5).target == null) {
                throw new SerializationException("IK target bone not found: " + (String)object4);
            }
            ((IkConstraintData)object5).mix = ((JsonValue)object6).getFloat("mix", 1.0f);
            ((IkConstraintData)object5).softness = ((JsonValue)object6).getFloat("softness", 0.0f) * f;
            ((IkConstraintData)object5).bendDirection = ((JsonValue)object6).getBoolean("bendPositive", true) ? 1 : -1;
            ((IkConstraintData)object5).compress = ((JsonValue)object6).getBoolean("compress", false);
            ((IkConstraintData)object5).stretch = ((JsonValue)object6).getBoolean("stretch", false);
            ((IkConstraintData)object5).uniform = ((JsonValue)object6).getBoolean("uniform", false);
            skeletonData.ikConstraints.add((IkConstraintData)object5);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("transform");
        while (object6 != null) {
            object5 = new TransformConstraintData(((JsonValue)object6).getString("name"));
            ((TransformConstraintData)object5).order = ((JsonValue)object6).getInt("order", 0);
            ((TransformConstraintData)object5).skinRequired = ((JsonValue)object6).getBoolean("skin", false);
            object4 = ((JsonValue)object6).getChild("bones");
            while (object4 != null) {
                object3 = skeletonData.findBone(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Transform constraint bone not found: " + (JsonValue)object4);
                }
                ((TransformConstraintData)object5).bones.add((BoneData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getString("target");
            ((TransformConstraintData)object5).target = skeletonData.findBone((String)object4);
            if (((TransformConstraintData)object5).target == null) {
                throw new SerializationException("Transform constraint target bone not found: " + (String)object4);
            }
            ((TransformConstraintData)object5).local = ((JsonValue)object6).getBoolean("local", false);
            ((TransformConstraintData)object5).relative = ((JsonValue)object6).getBoolean("relative", false);
            ((TransformConstraintData)object5).offsetRotation = ((JsonValue)object6).getFloat("rotation", 0.0f);
            ((TransformConstraintData)object5).offsetX = ((JsonValue)object6).getFloat("x", 0.0f) * f;
            ((TransformConstraintData)object5).offsetY = ((JsonValue)object6).getFloat("y", 0.0f) * f;
            ((TransformConstraintData)object5).offsetScaleX = ((JsonValue)object6).getFloat("scaleX", 0.0f);
            ((TransformConstraintData)object5).offsetScaleY = ((JsonValue)object6).getFloat("scaleY", 0.0f);
            ((TransformConstraintData)object5).offsetShearY = ((JsonValue)object6).getFloat("shearY", 0.0f);
            ((TransformConstraintData)object5).mixRotate = ((JsonValue)object6).getFloat("mixRotate", 1.0f);
            ((TransformConstraintData)object5).mixX = ((JsonValue)object6).getFloat("mixX", 1.0f);
            ((TransformConstraintData)object5).mixY = ((JsonValue)object6).getFloat("mixY", ((TransformConstraintData)object5).mixX);
            ((TransformConstraintData)object5).mixScaleX = ((JsonValue)object6).getFloat("mixScaleX", 1.0f);
            ((TransformConstraintData)object5).mixScaleY = ((JsonValue)object6).getFloat("mixScaleY", ((TransformConstraintData)object5).mixScaleX);
            ((TransformConstraintData)object5).mixShearY = ((JsonValue)object6).getFloat("mixShearY", 1.0f);
            skeletonData.transformConstraints.add((TransformConstraintData)object5);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("path");
        while (object6 != null) {
            object5 = new PathConstraintData(((JsonValue)object6).getString("name"));
            ((PathConstraintData)object5).order = ((JsonValue)object6).getInt("order", 0);
            ((PathConstraintData)object5).skinRequired = ((JsonValue)object6).getBoolean("skin", false);
            object4 = ((JsonValue)object6).getChild("bones");
            while (object4 != null) {
                object3 = skeletonData.findBone(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Path bone not found: " + (JsonValue)object4);
                }
                ((PathConstraintData)object5).bones.add((BoneData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getString("target");
            ((PathConstraintData)object5).target = skeletonData.findSlot((String)object4);
            if (((PathConstraintData)object5).target == null) {
                throw new SerializationException("Path target slot not found: " + (String)object4);
            }
            ((PathConstraintData)object5).positionMode = PathConstraintData.PositionMode.valueOf(((JsonValue)object6).getString("positionMode", "percent"));
            ((PathConstraintData)object5).spacingMode = PathConstraintData.SpacingMode.valueOf(((JsonValue)object6).getString("spacingMode", "length"));
            ((PathConstraintData)object5).rotateMode = PathConstraintData.RotateMode.valueOf(((JsonValue)object6).getString("rotateMode", "tangent"));
            ((PathConstraintData)object5).offsetRotation = ((JsonValue)object6).getFloat("rotation", 0.0f);
            ((PathConstraintData)object5).position = ((JsonValue)object6).getFloat("position", 0.0f);
            if (((PathConstraintData)object5).positionMode == PathConstraintData.PositionMode.fixed) {
                ((PathConstraintData)object5).position *= f;
            }
            ((PathConstraintData)object5).spacing = ((JsonValue)object6).getFloat("spacing", 0.0f);
            if (((PathConstraintData)object5).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object5).spacingMode == PathConstraintData.SpacingMode.fixed) {
                ((PathConstraintData)object5).spacing *= f;
            }
            ((PathConstraintData)object5).mixRotate = ((JsonValue)object6).getFloat("mixRotate", 1.0f);
            ((PathConstraintData)object5).mixX = ((JsonValue)object6).getFloat("mixX", 1.0f);
            ((PathConstraintData)object5).mixY = ((JsonValue)object6).getFloat("mixY", 1.0f);
            skeletonData.pathConstraints.add((PathConstraintData)object5);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("physics");
        while (object6 != null) {
            object5 = new PhysicsConstraintData(((JsonValue)object6).getString("name"));
            ((PhysicsConstraintData)object5).order = ((JsonValue)object6).getInt("order", 0);
            ((PhysicsConstraintData)object5).skinRequired = ((JsonValue)object6).getBoolean("skin", false);
            object4 = ((JsonValue)object6).getString("bone");
            ((PhysicsConstraintData)object5).bone = skeletonData.findBone((String)object4);
            if (((PhysicsConstraintData)object5).bone == null) {
                throw new SerializationException("Physics bone not found: " + (String)object4);
            }
            ((PhysicsConstraintData)object5).x = ((JsonValue)object6).getFloat("x", 0.0f);
            ((PhysicsConstraintData)object5).y = ((JsonValue)object6).getFloat("y", 0.0f);
            ((PhysicsConstraintData)object5).rotate = ((JsonValue)object6).getFloat("rotate", 0.0f);
            ((PhysicsConstraintData)object5).scaleX = ((JsonValue)object6).getFloat("scaleX", 0.0f);
            ((PhysicsConstraintData)object5).shearX = ((JsonValue)object6).getFloat("shearX", 0.0f);
            ((PhysicsConstraintData)object5).limit = ((JsonValue)object6).getFloat("limit", 5000.0f) * f;
            ((PhysicsConstraintData)object5).step = 1.0f / (float)((JsonValue)object6).getInt("fps", 60);
            ((PhysicsConstraintData)object5).inertia = ((JsonValue)object6).getFloat("inertia", 1.0f);
            ((PhysicsConstraintData)object5).strength = ((JsonValue)object6).getFloat("strength", 100.0f);
            ((PhysicsConstraintData)object5).damping = ((JsonValue)object6).getFloat("damping", 1.0f);
            ((PhysicsConstraintData)object5).massInverse = 1.0f / ((JsonValue)object6).getFloat("mass", 1.0f);
            ((PhysicsConstraintData)object5).wind = ((JsonValue)object6).getFloat("wind", 0.0f);
            ((PhysicsConstraintData)object5).gravity = ((JsonValue)object6).getFloat("gravity", 0.0f);
            ((PhysicsConstraintData)object5).mix = ((JsonValue)object6).getFloat("mix", 1.0f);
            ((PhysicsConstraintData)object5).inertiaGlobal = ((JsonValue)object6).getBoolean("inertiaGlobal", false);
            ((PhysicsConstraintData)object5).strengthGlobal = ((JsonValue)object6).getBoolean("strengthGlobal", false);
            ((PhysicsConstraintData)object5).dampingGlobal = ((JsonValue)object6).getBoolean("dampingGlobal", false);
            ((PhysicsConstraintData)object5).massGlobal = ((JsonValue)object6).getBoolean("massGlobal", false);
            ((PhysicsConstraintData)object5).windGlobal = ((JsonValue)object6).getBoolean("windGlobal", false);
            ((PhysicsConstraintData)object5).gravityGlobal = ((JsonValue)object6).getBoolean("gravityGlobal", false);
            ((PhysicsConstraintData)object5).mixGlobal = ((JsonValue)object6).getBoolean("mixGlobal", false);
            skeletonData.physicsConstraints.add((PhysicsConstraintData)object5);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("skins");
        while (object6 != null) {
            object5 = new Skin(((JsonValue)object6).getString("name"));
            object4 = ((JsonValue)object6).getChild("bones");
            while (object4 != null) {
                object3 = skeletonData.findBone(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Skin bone not found: " + (JsonValue)object4);
                }
                ((Skin)object5).bones.add((BoneData)object3);
                object4 = ((JsonValue)object4).next;
            }
            ((Skin)object5).bones.shrink();
            object4 = ((JsonValue)object6).getChild("ik");
            while (object4 != null) {
                object3 = skeletonData.findIkConstraint(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Skin IK constraint not found: " + (JsonValue)object4);
                }
                ((Skin)object5).constraints.add((ConstraintData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getChild("transform");
            while (object4 != null) {
                object3 = skeletonData.findTransformConstraint(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Skin transform constraint not found: " + (JsonValue)object4);
                }
                ((Skin)object5).constraints.add((ConstraintData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getChild("path");
            while (object4 != null) {
                object3 = skeletonData.findPathConstraint(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Skin path constraint not found: " + (JsonValue)object4);
                }
                ((Skin)object5).constraints.add((ConstraintData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getChild("physics");
            while (object4 != null) {
                object3 = skeletonData.findPhysicsConstraint(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Skin physics constraint not found: " + (JsonValue)object4);
                }
                ((Skin)object5).constraints.add((ConstraintData)object3);
                object4 = ((JsonValue)object4).next;
            }
            ((Skin)object5).constraints.shrink();
            object4 = ((JsonValue)object6).getChild("attachments");
            while (object4 != null) {
                object3 = skeletonData.findSlot(((JsonValue)object4).name);
                if (object3 == null) {
                    throw new SerializationException("Slot not found: " + ((JsonValue)object4).name);
                }
                object2 = ((JsonValue)object4).child;
                while (object2 != null) {
                    try {
                        object = this.readAttachment((JsonValue)object2, (Skin)object5, ((SlotData)object3).index, ((JsonValue)object2).name, skeletonData);
                        if (object != null) {
                            ((Skin)object5).setAttachment(((SlotData)object3).index, ((JsonValue)object2).name, (Attachment)object);
                        }
                    }
                    catch (Throwable throwable) {
                        throw new SerializationException("Error reading attachment: " + ((JsonValue)object2).name + ", skin: " + (Skin)object5, throwable);
                    }
                    object2 = ((JsonValue)object2).next;
                }
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getString("color", null);
            if (object4 != null) {
                Color.valueOf((String)object4, ((Skin)object5).getColor());
            }
            skeletonData.skins.add((Skin)object5);
            if (((Skin)object5).name.equals("default")) {
                skeletonData.defaultSkin = object5;
            }
            object6 = ((JsonValue)object6).next;
        }
        object6 = this.linkedMeshes.items;
        int n = this.linkedMeshes.size;
        for (int i = 0; i < n; ++i) {
            object3 = (LinkedMesh)object6[i];
            Object object7 = object2 = ((LinkedMesh)object3).skin == null ? skeletonData.getDefaultSkin() : skeletonData.findSkin(((LinkedMesh)object3).skin);
            if (object2 == null) {
                throw new SerializationException("Skin not found: " + ((LinkedMesh)object3).skin);
            }
            object = ((Skin)object2).getAttachment(((LinkedMesh)object3).slotIndex, ((LinkedMesh)object3).parent);
            if (object == null) {
                throw new SerializationException("Parent mesh not found: " + ((LinkedMesh)object3).parent);
            }
            ((LinkedMesh)object3).mesh.setTimelineAttachment(((LinkedMesh)object3).inheritTimelines ? (VertexAttachment)object : ((LinkedMesh)object3).mesh);
            ((LinkedMesh)object3).mesh.setParentMesh((MeshAttachment)object);
            if (((LinkedMesh)object3).mesh.getRegion() == null) continue;
            ((LinkedMesh)object3).mesh.updateRegion();
        }
        this.linkedMeshes.clear();
        JsonValue jsonValue3 = jsonValue.getChild("events");
        while (jsonValue3 != null) {
            EventData eventData = new EventData(jsonValue3.name);
            eventData.intValue = jsonValue3.getInt("int", 0);
            eventData.floatValue = jsonValue3.getFloat("float", 0.0f);
            eventData.stringValue = jsonValue3.getString("string", "");
            eventData.audioPath = jsonValue3.getString("audio", null);
            if (eventData.audioPath != null) {
                eventData.volume = jsonValue3.getFloat("volume", 1.0f);
                eventData.balance = jsonValue3.getFloat("balance", 0.0f);
            }
            skeletonData.events.add(eventData);
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("animations");
        while (jsonValue3 != null) {
            try {
                this.readAnimation(jsonValue3, jsonValue3.name, skeletonData);
            }
            catch (Throwable throwable) {
                throw new SerializationException("Error reading animation: " + jsonValue3.name, throwable);
            }
            jsonValue3 = jsonValue3.next;
        }
        skeletonData.bones.shrink();
        skeletonData.slots.shrink();
        skeletonData.skins.shrink();
        skeletonData.events.shrink();
        skeletonData.animations.shrink();
        skeletonData.ikConstraints.shrink();
        return skeletonData;
    }

    private Attachment readAttachment(JsonValue jsonValue, Skin skin, int n, String string, SkeletonData skeletonData) {
        float f = this.scale;
        string = jsonValue.getString("name", string);
        switch (AttachmentType.valueOf(jsonValue.getString("type", AttachmentType.region.name()))) {
            case region: {
                String string2 = jsonValue.getString("path", string);
                Sequence sequence = this.readSequence(jsonValue.get("sequence"));
                RegionAttachment regionAttachment = this.attachmentLoader.newRegionAttachment(skin, string, string2, sequence);
                if (regionAttachment == null) {
                    return null;
                }
                regionAttachment.setPath(string2);
                regionAttachment.setX(jsonValue.getFloat("x", 0.0f) * f);
                regionAttachment.setY(jsonValue.getFloat("y", 0.0f) * f);
                regionAttachment.setScaleX(jsonValue.getFloat("scaleX", 1.0f));
                regionAttachment.setScaleY(jsonValue.getFloat("scaleY", 1.0f));
                regionAttachment.setRotation(jsonValue.getFloat("rotation", 0.0f));
                regionAttachment.setWidth(jsonValue.getFloat("width") * f);
                regionAttachment.setHeight(jsonValue.getFloat("height") * f);
                regionAttachment.setSequence(sequence);
                String string3 = jsonValue.getString("color", null);
                if (string3 != null) {
                    Color.valueOf(string3, regionAttachment.getColor());
                }
                if (regionAttachment.getRegion() != null) {
                    regionAttachment.updateRegion();
                }
                return regionAttachment;
            }
            case boundingbox: {
                BoundingBoxAttachment boundingBoxAttachment = this.attachmentLoader.newBoundingBoxAttachment(skin, string);
                if (boundingBoxAttachment == null) {
                    return null;
                }
                this.readVertices(jsonValue, boundingBoxAttachment, jsonValue.getInt("vertexCount") << 1);
                String string4 = jsonValue.getString("color", null);
                if (string4 != null) {
                    Color.valueOf(string4, boundingBoxAttachment.getColor());
                }
                return boundingBoxAttachment;
            }
            case mesh: 
            case linkedmesh: {
                String string5 = jsonValue.getString("path", string);
                Sequence sequence = this.readSequence(jsonValue.get("sequence"));
                MeshAttachment meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string, string5, sequence);
                if (meshAttachment == null) {
                    return null;
                }
                meshAttachment.setPath(string5);
                String string6 = jsonValue.getString("color", null);
                if (string6 != null) {
                    Color.valueOf(string6, meshAttachment.getColor());
                }
                meshAttachment.setWidth(jsonValue.getFloat("width", 0.0f) * f);
                meshAttachment.setHeight(jsonValue.getFloat("height", 0.0f) * f);
                meshAttachment.setSequence(sequence);
                String string7 = jsonValue.getString("parent", null);
                if (string7 != null) {
                    this.linkedMeshes.add(new LinkedMesh(meshAttachment, jsonValue.getString("skin", null), n, string7, jsonValue.getBoolean("timelines", true)));
                    return meshAttachment;
                }
                float[] fArray = jsonValue.require("uvs").asFloatArray();
                this.readVertices(jsonValue, meshAttachment, fArray.length);
                meshAttachment.setTriangles(jsonValue.require("triangles").asShortArray());
                meshAttachment.setRegionUVs(fArray);
                if (meshAttachment.getRegion() != null) {
                    meshAttachment.updateRegion();
                }
                if (jsonValue.has("hull")) {
                    meshAttachment.setHullLength(jsonValue.require("hull").asInt() << 1);
                }
                if (jsonValue.has("edges")) {
                    meshAttachment.setEdges(jsonValue.require("edges").asShortArray());
                }
                return meshAttachment;
            }
            case path: {
                PathAttachment pathAttachment = this.attachmentLoader.newPathAttachment(skin, string);
                if (pathAttachment == null) {
                    return null;
                }
                pathAttachment.setClosed(jsonValue.getBoolean("closed", false));
                pathAttachment.setConstantSpeed(jsonValue.getBoolean("constantSpeed", true));
                int n2 = jsonValue.getInt("vertexCount");
                this.readVertices(jsonValue, pathAttachment, n2 << 1);
                float[] fArray = new float[n2 / 3];
                int n3 = 0;
                Object object = jsonValue.require((String)"lengths").child;
                while (object != null) {
                    fArray[n3++] = ((JsonValue)object).asFloat() * f;
                    object = ((JsonValue)object).next;
                }
                pathAttachment.setLengths(fArray);
                object = jsonValue.getString("color", null);
                if (object != null) {
                    Color.valueOf((String)object, pathAttachment.getColor());
                }
                return pathAttachment;
            }
            case point: {
                PointAttachment pointAttachment = this.attachmentLoader.newPointAttachment(skin, string);
                if (pointAttachment == null) {
                    return null;
                }
                pointAttachment.setX(jsonValue.getFloat("x", 0.0f) * f);
                pointAttachment.setY(jsonValue.getFloat("y", 0.0f) * f);
                pointAttachment.setRotation(jsonValue.getFloat("rotation", 0.0f));
                String string8 = jsonValue.getString("color", null);
                if (string8 != null) {
                    Color.valueOf(string8, pointAttachment.getColor());
                }
                return pointAttachment;
            }
            case clipping: {
                Object object;
                ClippingAttachment clippingAttachment = this.attachmentLoader.newClippingAttachment(skin, string);
                if (clippingAttachment == null) {
                    return null;
                }
                String string9 = jsonValue.getString("end", null);
                if (string9 != null) {
                    object = skeletonData.findSlot(string9);
                    if (object == null) {
                        throw new SerializationException("Clipping end slot not found: " + string9);
                    }
                    clippingAttachment.setEndSlot((SlotData)object);
                }
                this.readVertices(jsonValue, clippingAttachment, jsonValue.getInt("vertexCount") << 1);
                object = jsonValue.getString("color", null);
                if (object != null) {
                    Color.valueOf((String)object, clippingAttachment.getColor());
                }
                return clippingAttachment;
            }
        }
        return null;
    }

    private Sequence readSequence(JsonValue jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        Sequence sequence = new Sequence(jsonValue.getInt("count"));
        sequence.setStart(jsonValue.getInt("start", 1));
        sequence.setDigits(jsonValue.getInt("digits", 0));
        sequence.setSetupIndex(jsonValue.getInt("setup", 0));
        return sequence;
    }

    private void readVertices(JsonValue jsonValue, VertexAttachment vertexAttachment, int n) {
        vertexAttachment.setWorldVerticesLength(n);
        float[] fArray = jsonValue.require("vertices").asFloatArray();
        if (n == fArray.length) {
            if (this.scale != 1.0f) {
                int n2 = 0;
                int n3 = fArray.length;
                while (n2 < n3) {
                    int n4 = n2++;
                    fArray[n4] = fArray[n4] * this.scale;
                }
            }
            vertexAttachment.setVertices(fArray);
            return;
        }
        FloatArray floatArray = new FloatArray(n * 3 * 3);
        IntArray intArray = new IntArray(n * 3);
        int n5 = 0;
        int n6 = fArray.length;
        while (n5 < n6) {
            int n7 = (int)fArray[n5++];
            intArray.add(n7);
            int n8 = n5 + (n7 << 2);
            while (n5 < n8) {
                intArray.add((int)fArray[n5]);
                floatArray.add(fArray[n5 + 1] * this.scale);
                floatArray.add(fArray[n5 + 2] * this.scale);
                floatArray.add(fArray[n5 + 3]);
                n5 += 4;
            }
        }
        vertexAttachment.setBones(intArray.toArray());
        vertexAttachment.setVertices(floatArray.toArray());
    }

    private void readAnimation(JsonValue jsonValue, String string, SkeletonData skeletonData) {
        JsonValue jsonValue2;
        JsonValue jsonValue3;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        int n;
        Animation.Timeline timeline;
        String string2;
        int n2;
        Object object;
        Object object2;
        Object object3;
        float f6 = this.scale;
        Array<Animation.Timeline> array = new Array<Animation.Timeline>();
        JsonValue jsonValue4 = jsonValue.getChild("slots");
        while (jsonValue4 != null) {
            object3 = skeletonData.findSlot(jsonValue4.name);
            if (object3 == null) {
                throw new SerializationException("Slot not found: " + jsonValue4.name);
            }
            object2 = jsonValue4.child;
            while (object2 != null) {
                object = ((JsonValue)object2).child;
                if (object != null) {
                    n2 = ((JsonValue)object2).size;
                    string2 = ((JsonValue)object2).name;
                    if (string2.equals("attachment")) {
                        timeline = new Animation.AttachmentTimeline(n2, ((SlotData)object3).index);
                        n = 0;
                        while (object != null) {
                            ((Animation.AttachmentTimeline)timeline).setFrame(n, ((JsonValue)object).getFloat("time", 0.0f), ((JsonValue)object).getString("name", null));
                            object = ((JsonValue)object).next;
                            ++n;
                        }
                        array.add(timeline);
                    } else if (string2.equals("rgba")) {
                        timeline = new Animation.RGBATimeline(n2, n2 << 2, ((SlotData)object3).index);
                        float f7 = ((JsonValue)object).getFloat("time", 0.0f);
                        var14_63 = ((JsonValue)object).getString("color");
                        var15_71 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                        f5 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                        f4 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                        f3 = (float)Integer.parseInt(var14_63.substring(6, 8), 16) / 255.0f;
                        int n3 = 0;
                        int n4 = 0;
                        while (true) {
                            ((Animation.RGBATimeline)timeline).setFrame(n3, f7, var15_71, f5, f4, f3);
                            JsonValue jsonValue5 = ((JsonValue)object).next;
                            if (jsonValue5 == null) break;
                            float f8 = jsonValue5.getFloat("time", 0.0f);
                            var14_63 = jsonValue5.getString("color");
                            float f9 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                            float f10 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                            f2 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                            f = (float)Integer.parseInt(var14_63.substring(6, 8), 16) / 255.0f;
                            jsonValue3 = ((JsonValue)object).get("curve");
                            if (jsonValue3 != null) {
                                n4 = this.readCurve(jsonValue3, (Animation.CurveTimeline)timeline, n4, n3, 0, f7, f8, var15_71, f9, 1.0f);
                                n4 = this.readCurve(jsonValue3, (Animation.CurveTimeline)timeline, n4, n3, 1, f7, f8, f5, f10, 1.0f);
                                n4 = this.readCurve(jsonValue3, (Animation.CurveTimeline)timeline, n4, n3, 2, f7, f8, f4, f2, 1.0f);
                                n4 = this.readCurve(jsonValue3, (Animation.CurveTimeline)timeline, n4, n3, 3, f7, f8, f3, f, 1.0f);
                            }
                            f7 = f8;
                            var15_71 = f9;
                            f5 = f10;
                            f4 = f2;
                            f3 = f;
                            object = jsonValue5;
                            ++n3;
                        }
                        ((Animation.CurveTimeline)timeline).shrink(n4);
                        array.add(timeline);
                    } else if (string2.equals("rgb")) {
                        timeline = new Animation.RGBTimeline(n2, n2 * 3, ((SlotData)object3).index);
                        float f11 = ((JsonValue)object).getFloat("time", 0.0f);
                        var14_63 = ((JsonValue)object).getString("color");
                        var15_71 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                        f5 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                        f4 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                        int n5 = 0;
                        int n6 = 0;
                        while (true) {
                            ((Animation.RGBTimeline)timeline).setFrame(n5, f11, var15_71, f5, f4);
                            JsonValue jsonValue6 = ((JsonValue)object).next;
                            if (jsonValue6 == null) break;
                            float f12 = jsonValue6.getFloat("time", 0.0f);
                            var14_63 = jsonValue6.getString("color");
                            float f13 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                            float f14 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                            float f15 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                            JsonValue jsonValue7 = ((JsonValue)object).get("curve");
                            if (jsonValue7 != null) {
                                n6 = this.readCurve(jsonValue7, (Animation.CurveTimeline)timeline, n6, n5, 0, f11, f12, var15_71, f13, 1.0f);
                                n6 = this.readCurve(jsonValue7, (Animation.CurveTimeline)timeline, n6, n5, 1, f11, f12, f5, f14, 1.0f);
                                n6 = this.readCurve(jsonValue7, (Animation.CurveTimeline)timeline, n6, n5, 2, f11, f12, f4, f15, 1.0f);
                            }
                            f11 = f12;
                            var15_71 = f13;
                            f5 = f14;
                            f4 = f15;
                            object = jsonValue6;
                            ++n5;
                        }
                        ((Animation.CurveTimeline)timeline).shrink(n6);
                        array.add(timeline);
                    } else if (string2.equals("alpha")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.AlphaTimeline(n2, n2, ((SlotData)object3).index), 0.0f, 1.0f));
                    } else if (string2.equals("rgba2")) {
                        timeline = new Animation.RGBA2Timeline(n2, n2 * 7, ((SlotData)object3).index);
                        float f16 = ((JsonValue)object).getFloat("time", 0.0f);
                        var14_63 = ((JsonValue)object).getString("light");
                        var15_71 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                        f5 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                        f4 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                        f3 = (float)Integer.parseInt(var14_63.substring(6, 8), 16) / 255.0f;
                        var14_63 = ((JsonValue)object).getString("dark");
                        float f17 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                        float f18 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                        float f19 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                        var22_121 = 0;
                        int n7 = 0;
                        while (true) {
                            ((Animation.RGBA2Timeline)timeline).setFrame(var22_121, f16, var15_71, f5, f4, f3, f17, f18, f19);
                            JsonValue jsonValue8 = ((JsonValue)object).next;
                            if (jsonValue8 == null) break;
                            f2 = jsonValue8.getFloat("time", 0.0f);
                            var14_63 = jsonValue8.getString("light");
                            f = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                            float f20 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                            var28_153 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                            var29_157 = (float)Integer.parseInt(var14_63.substring(6, 8), 16) / 255.0f;
                            var14_63 = jsonValue8.getString("dark");
                            var30_158 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                            float f21 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                            float f22 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                            JsonValue jsonValue9 = ((JsonValue)object).get("curve");
                            if (jsonValue9 != null) {
                                n7 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n7, var22_121, 0, f16, f2, var15_71, f, 1.0f);
                                n7 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n7, var22_121, 1, f16, f2, f5, f20, 1.0f);
                                n7 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n7, var22_121, 2, f16, f2, f4, var28_153, 1.0f);
                                n7 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n7, var22_121, 3, f16, f2, f3, var29_157, 1.0f);
                                n7 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n7, var22_121, 4, f16, f2, f17, var30_158, 1.0f);
                                n7 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n7, var22_121, 5, f16, f2, f18, f21, 1.0f);
                                n7 = this.readCurve(jsonValue9, (Animation.CurveTimeline)timeline, n7, var22_121, 6, f16, f2, f19, f22, 1.0f);
                            }
                            f16 = f2;
                            var15_71 = f;
                            f5 = f20;
                            f4 = var28_153;
                            f3 = var29_157;
                            f17 = var30_158;
                            f18 = f21;
                            f19 = f22;
                            object = jsonValue8;
                            ++var22_121;
                        }
                        ((Animation.CurveTimeline)timeline).shrink(n7);
                        array.add(timeline);
                    } else if (string2.equals("rgb2")) {
                        timeline = new Animation.RGB2Timeline(n2, n2 * 6, ((SlotData)object3).index);
                        float f23 = ((JsonValue)object).getFloat("time", 0.0f);
                        var14_63 = ((JsonValue)object).getString("light");
                        var15_71 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                        f5 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                        f4 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                        var14_63 = ((JsonValue)object).getString("dark");
                        f3 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                        float f24 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                        float f25 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                        int n8 = 0;
                        var22_121 = 0;
                        while (true) {
                            ((Animation.RGB2Timeline)timeline).setFrame(n8, f23, var15_71, f5, f4, f3, f24, f25);
                            JsonValue jsonValue10 = ((JsonValue)object).next;
                            if (jsonValue10 == null) break;
                            float f26 = jsonValue10.getFloat("time", 0.0f);
                            var14_63 = jsonValue10.getString("light");
                            f2 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                            f = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                            float f27 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                            var14_63 = jsonValue10.getString("dark");
                            var28_153 = (float)Integer.parseInt(var14_63.substring(0, 2), 16) / 255.0f;
                            var29_157 = (float)Integer.parseInt(var14_63.substring(2, 4), 16) / 255.0f;
                            var30_158 = (float)Integer.parseInt(var14_63.substring(4, 6), 16) / 255.0f;
                            JsonValue jsonValue11 = ((JsonValue)object).get("curve");
                            if (jsonValue11 != null) {
                                var22_121 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, var22_121, n8, 0, f23, f26, var15_71, f2, 1.0f);
                                var22_121 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, var22_121, n8, 1, f23, f26, f5, f, 1.0f);
                                var22_121 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, var22_121, n8, 2, f23, f26, f4, f27, 1.0f);
                                var22_121 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, var22_121, n8, 3, f23, f26, f3, var28_153, 1.0f);
                                var22_121 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, var22_121, n8, 4, f23, f26, f24, var29_157, 1.0f);
                                var22_121 = this.readCurve(jsonValue11, (Animation.CurveTimeline)timeline, var22_121, n8, 5, f23, f26, f25, var30_158, 1.0f);
                            }
                            f23 = f26;
                            var15_71 = f2;
                            f5 = f;
                            f4 = f27;
                            f3 = var28_153;
                            f24 = var29_157;
                            f25 = var30_158;
                            object = jsonValue10;
                            ++n8;
                        }
                        ((Animation.CurveTimeline)timeline).shrink(var22_121);
                        array.add(timeline);
                    } else {
                        throw new RuntimeException("Invalid timeline type for a slot: " + string2 + " (" + jsonValue4.name + ")");
                    }
                }
                object2 = ((JsonValue)object2).next;
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("bones");
        while (jsonValue4 != null) {
            object3 = skeletonData.findBone(jsonValue4.name);
            if (object3 == null) {
                throw new SerializationException("Bone not found: " + jsonValue4.name);
            }
            object2 = jsonValue4.child;
            while (object2 != null) {
                object = ((JsonValue)object2).child;
                if (object != null) {
                    n2 = ((JsonValue)object2).size;
                    string2 = ((JsonValue)object2).name;
                    if (string2.equals("rotate")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.RotateTimeline(n2, n2, ((BoneData)object3).index), 0.0f, 1.0f));
                    } else if (string2.equals("translate")) {
                        timeline = new Animation.TranslateTimeline(n2, n2 << 1, ((BoneData)object3).index);
                        array.add(this.readTimeline((JsonValue)object, (Animation.CurveTimeline2)timeline, "x", "y", 0.0f, f6));
                    } else if (string2.equals("translatex")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.TranslateXTimeline(n2, n2, ((BoneData)object3).index), 0.0f, f6));
                    } else if (string2.equals("translatey")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.TranslateYTimeline(n2, n2, ((BoneData)object3).index), 0.0f, f6));
                    } else if (string2.equals("scale")) {
                        timeline = new Animation.ScaleTimeline(n2, n2 << 1, ((BoneData)object3).index);
                        array.add(this.readTimeline((JsonValue)object, (Animation.CurveTimeline2)timeline, "x", "y", 1.0f, 1.0f));
                    } else if (string2.equals("scalex")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.ScaleXTimeline(n2, n2, ((BoneData)object3).index), 1.0f, 1.0f));
                    } else if (string2.equals("scaley")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.ScaleYTimeline(n2, n2, ((BoneData)object3).index), 1.0f, 1.0f));
                    } else if (string2.equals("shear")) {
                        timeline = new Animation.ShearTimeline(n2, n2 << 1, ((BoneData)object3).index);
                        array.add(this.readTimeline((JsonValue)object, (Animation.CurveTimeline2)timeline, "x", "y", 0.0f, 1.0f));
                    } else if (string2.equals("shearx")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.ShearXTimeline(n2, n2, ((BoneData)object3).index), 0.0f, 1.0f));
                    } else if (string2.equals("sheary")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.ShearYTimeline(n2, n2, ((BoneData)object3).index), 0.0f, 1.0f));
                    } else if (string2.equals("inherit")) {
                        timeline = new Animation.InheritTimeline(n2, ((BoneData)object3).index);
                        n = 0;
                        while (object != null) {
                            float f28 = ((JsonValue)object).getFloat("time", 0.0f);
                            ((Animation.InheritTimeline)timeline).setFrame(n, f28, BoneData.Inherit.valueOf(((JsonValue)object).getString("inherit", BoneData.Inherit.normal.name())));
                            object = ((JsonValue)object).next;
                            ++n;
                        }
                        array.add(timeline);
                    } else {
                        throw new RuntimeException("Invalid timeline type for a bone: " + string2 + " (" + jsonValue4.name + ")");
                    }
                }
                object2 = ((JsonValue)object2).next;
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("ik");
        while (jsonValue4 != null) {
            object3 = jsonValue4.child;
            if (object3 != null) {
                object2 = skeletonData.findIkConstraint(jsonValue4.name);
                object = new Animation.IkConstraintTimeline(jsonValue4.size, jsonValue4.size << 1, skeletonData.getIkConstraints().indexOf((IkConstraintData)object2, true));
                float f29 = ((JsonValue)object3).getFloat("time", 0.0f);
                float f30 = ((JsonValue)object3).getFloat("mix", 1.0f);
                float f31 = ((JsonValue)object3).getFloat("softness", 0.0f) * f6;
                n = 0;
                int n9 = 0;
                while (true) {
                    ((Animation.IkConstraintTimeline)object).setFrame(n, f29, f30, f31, ((JsonValue)object3).getBoolean("bendPositive", true) ? 1 : -1, ((JsonValue)object3).getBoolean("compress", false), ((JsonValue)object3).getBoolean("stretch", false));
                    JsonValue jsonValue12 = ((JsonValue)object3).next;
                    if (jsonValue12 == null) break;
                    f5 = jsonValue12.getFloat("time", 0.0f);
                    f4 = jsonValue12.getFloat("mix", 1.0f);
                    f3 = jsonValue12.getFloat("softness", 0.0f) * f6;
                    JsonValue jsonValue13 = ((JsonValue)object3).get("curve");
                    if (jsonValue13 != null) {
                        n9 = this.readCurve(jsonValue13, (Animation.CurveTimeline)object, n9, n, 0, f29, f5, f30, f4, 1.0f);
                        n9 = this.readCurve(jsonValue13, (Animation.CurveTimeline)object, n9, n, 1, f29, f5, f31, f3, f6);
                    }
                    f29 = f5;
                    f30 = f4;
                    f31 = f3;
                    object3 = jsonValue12;
                    ++n;
                }
                ((Animation.CurveTimeline)object).shrink(n9);
                array.add((Animation.Timeline)object);
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("transform");
        while (jsonValue4 != null) {
            object3 = jsonValue4.child;
            if (object3 != null) {
                object2 = skeletonData.findTransformConstraint(jsonValue4.name);
                object = new Animation.TransformConstraintTimeline(jsonValue4.size, jsonValue4.size * 6, skeletonData.getTransformConstraints().indexOf((TransformConstraintData)object2, true));
                float f32 = ((JsonValue)object3).getFloat("time", 0.0f);
                float f33 = ((JsonValue)object3).getFloat("mixRotate", 1.0f);
                float f34 = ((JsonValue)object3).getFloat("mixX", 1.0f);
                float f35 = ((JsonValue)object3).getFloat("mixY", f34);
                float f36 = ((JsonValue)object3).getFloat("mixScaleX", 1.0f);
                float f37 = ((JsonValue)object3).getFloat("mixScaleY", f36);
                f5 = ((JsonValue)object3).getFloat("mixShearY", 1.0f);
                int n10 = 0;
                int n11 = 0;
                while (true) {
                    ((Animation.TransformConstraintTimeline)object).setFrame(n10, f32, f33, f34, f35, f36, f37, f5);
                    JsonValue jsonValue14 = ((JsonValue)object3).next;
                    if (jsonValue14 == null) break;
                    float f38 = jsonValue14.getFloat("time", 0.0f);
                    float f39 = jsonValue14.getFloat("mixRotate", 1.0f);
                    float f40 = jsonValue14.getFloat("mixX", 1.0f);
                    float f41 = jsonValue14.getFloat("mixY", f40);
                    float f42 = jsonValue14.getFloat("mixScaleX", 1.0f);
                    f2 = jsonValue14.getFloat("mixScaleY", f42);
                    f = jsonValue14.getFloat("mixShearY", 1.0f);
                    jsonValue3 = ((JsonValue)object3).get("curve");
                    if (jsonValue3 != null) {
                        n11 = this.readCurve(jsonValue3, (Animation.CurveTimeline)object, n11, n10, 0, f32, f38, f33, f39, 1.0f);
                        n11 = this.readCurve(jsonValue3, (Animation.CurveTimeline)object, n11, n10, 1, f32, f38, f34, f40, 1.0f);
                        n11 = this.readCurve(jsonValue3, (Animation.CurveTimeline)object, n11, n10, 2, f32, f38, f35, f41, 1.0f);
                        n11 = this.readCurve(jsonValue3, (Animation.CurveTimeline)object, n11, n10, 3, f32, f38, f36, f42, 1.0f);
                        n11 = this.readCurve(jsonValue3, (Animation.CurveTimeline)object, n11, n10, 4, f32, f38, f37, f2, 1.0f);
                        n11 = this.readCurve(jsonValue3, (Animation.CurveTimeline)object, n11, n10, 5, f32, f38, f5, f, 1.0f);
                    }
                    f32 = f38;
                    f33 = f39;
                    f34 = f40;
                    f35 = f41;
                    f36 = f42;
                    f37 = f2;
                    f5 = f;
                    object3 = jsonValue14;
                    ++n10;
                }
                ((Animation.CurveTimeline)object).shrink(n11);
                array.add((Animation.Timeline)object);
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("path");
        while (jsonValue4 != null) {
            object3 = skeletonData.findPathConstraint(jsonValue4.name);
            if (object3 == null) {
                throw new SerializationException("Path constraint not found: " + jsonValue4.name);
            }
            int n12 = skeletonData.pathConstraints.indexOf((PathConstraintData)object3, true);
            object = jsonValue4.child;
            while (object != null) {
                JsonValue jsonValue15 = ((JsonValue)object).child;
                if (jsonValue15 != null) {
                    int n13 = ((JsonValue)object).size;
                    String string3 = ((JsonValue)object).name;
                    if (string3.equals("position")) {
                        var13_58 = new Animation.PathConstraintPositionTimeline(n13, n13, n12);
                        array.add(this.readTimeline(jsonValue15, (Animation.CurveTimeline1)var13_58, 0.0f, ((PathConstraintData)object3).positionMode == PathConstraintData.PositionMode.fixed ? f6 : 1.0f));
                    } else if (string3.equals("spacing")) {
                        var13_58 = new Animation.PathConstraintSpacingTimeline(n13, n13, n12);
                        array.add(this.readTimeline(jsonValue15, (Animation.CurveTimeline1)var13_58, 0.0f, ((PathConstraintData)object3).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object3).spacingMode == PathConstraintData.SpacingMode.fixed ? f6 : 1.0f));
                    } else if (string3.equals("mix")) {
                        var13_58 = new Animation.PathConstraintMixTimeline(n13, n13 * 3, n12);
                        float f43 = jsonValue15.getFloat("time", 0.0f);
                        float f44 = jsonValue15.getFloat("mixRotate", 1.0f);
                        f5 = jsonValue15.getFloat("mixX", 1.0f);
                        float f45 = jsonValue15.getFloat("mixY", f5);
                        int n14 = 0;
                        int n15 = 0;
                        while (true) {
                            ((Animation.PathConstraintMixTimeline)var13_58).setFrame(n14, f43, f44, f5, f45);
                            JsonValue jsonValue16 = jsonValue15.next;
                            if (jsonValue16 == null) break;
                            float f46 = jsonValue16.getFloat("time", 0.0f);
                            float f47 = jsonValue16.getFloat("mixRotate", 1.0f);
                            float f48 = jsonValue16.getFloat("mixX", 1.0f);
                            float f49 = jsonValue16.getFloat("mixY", f48);
                            JsonValue jsonValue17 = jsonValue15.get("curve");
                            if (jsonValue17 != null) {
                                n15 = this.readCurve(jsonValue17, var13_58, n15, n14, 0, f43, f46, f44, f47, 1.0f);
                                n15 = this.readCurve(jsonValue17, var13_58, n15, n14, 1, f43, f46, f5, f48, 1.0f);
                                n15 = this.readCurve(jsonValue17, var13_58, n15, n14, 2, f43, f46, f45, f49, 1.0f);
                            }
                            f43 = f46;
                            f44 = f47;
                            f5 = f48;
                            f45 = f49;
                            jsonValue15 = jsonValue16;
                            ++n14;
                        }
                        var13_58.shrink(n15);
                        array.add(var13_58);
                    }
                }
                object = ((JsonValue)object).next;
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("physics");
        while (jsonValue4 != null) {
            Object object4;
            int n16 = -1;
            if (!jsonValue4.name.isEmpty()) {
                object4 = skeletonData.findPhysicsConstraint(jsonValue4.name);
                if (object4 == null) {
                    throw new SerializationException("Physics constraint not found: " + jsonValue4.name);
                }
                n16 = skeletonData.physicsConstraints.indexOf((PhysicsConstraintData)object4, true);
            }
            object4 = jsonValue4.child;
            while (object4 != null) {
                block112: {
                    Animation.Timeline timeline2;
                    block115: {
                        String string4;
                        int n17;
                        block120: {
                            block119: {
                                block118: {
                                    block117: {
                                        block116: {
                                            block114: {
                                                block113: {
                                                    object = ((JsonValue)object4).child;
                                                    if (object == null) break block112;
                                                    n17 = ((JsonValue)object4).size;
                                                    string4 = ((JsonValue)object4).name;
                                                    if (!string4.equals("reset")) break block113;
                                                    timeline2 = new Animation.PhysicsConstraintResetTimeline(n17, n16);
                                                    int n18 = 0;
                                                    while (object != null) {
                                                        timeline2.setFrame(n18, ((JsonValue)object).getFloat("time", 0.0f));
                                                        object = ((JsonValue)object).next;
                                                        ++n18;
                                                    }
                                                    array.add(timeline2);
                                                    break block112;
                                                }
                                                if (!string4.equals("inertia")) break block114;
                                                timeline2 = new Animation.PhysicsConstraintInertiaTimeline(n17, n17, n16);
                                                break block115;
                                            }
                                            if (!string4.equals("strength")) break block116;
                                            timeline2 = new Animation.PhysicsConstraintStrengthTimeline(n17, n17, n16);
                                            break block115;
                                        }
                                        if (!string4.equals("damping")) break block117;
                                        timeline2 = new Animation.PhysicsConstraintDampingTimeline(n17, n17, n16);
                                        break block115;
                                    }
                                    if (!string4.equals("mass")) break block118;
                                    timeline2 = new Animation.PhysicsConstraintMassTimeline(n17, n17, n16);
                                    break block115;
                                }
                                if (!string4.equals("wind")) break block119;
                                timeline2 = new Animation.PhysicsConstraintWindTimeline(n17, n17, n16);
                                break block115;
                            }
                            if (!string4.equals("gravity")) break block120;
                            timeline2 = new Animation.PhysicsConstraintGravityTimeline(n17, n17, n16);
                            break block115;
                        }
                        if (!string4.equals("mix")) break block112;
                        timeline2 = new Animation.PhysicsConstraintMixTimeline(n17, n17, n16);
                    }
                    array.add(this.readTimeline((JsonValue)object, (Animation.CurveTimeline1)timeline2, 0.0f, 1.0f));
                }
                object4 = ((JsonValue)object4).next;
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("attachments");
        while (jsonValue4 != null) {
            Skin skin = skeletonData.findSkin(jsonValue4.name);
            if (skin == null) {
                throw new SerializationException("Skin not found: " + jsonValue4.name);
            }
            JsonValue jsonValue18 = jsonValue4.child;
            while (jsonValue18 != null) {
                object = skeletonData.findSlot(jsonValue18.name);
                if (object == null) {
                    throw new SerializationException("Slot not found: " + jsonValue18.name);
                }
                JsonValue jsonValue19 = jsonValue18.child;
                while (jsonValue19 != null) {
                    Attachment attachment = skin.getAttachment(((SlotData)object).index, jsonValue19.name);
                    if (attachment == null) {
                        throw new SerializationException("Timeline attachment not found: " + jsonValue19.name);
                    }
                    JsonValue jsonValue20 = jsonValue19.child;
                    while (jsonValue20 != null) {
                        JsonValue jsonValue21 = jsonValue20.child;
                        int n19 = jsonValue20.size;
                        String string5 = jsonValue20.name;
                        if (string5.equals("deform")) {
                            var16_80 = (VertexAttachment)attachment;
                            boolean bl = ((VertexAttachment)var16_80).getBones() != null;
                            float[] fArray = ((VertexAttachment)var16_80).getVertices();
                            int n20 = bl ? fArray.length / 3 << 1 : fArray.length;
                            Animation.DeformTimeline deformTimeline = new Animation.DeformTimeline(n19, n19, ((SlotData)object).index, (VertexAttachment)var16_80);
                            float f50 = jsonValue21.getFloat("time", 0.0f);
                            int n21 = 0;
                            int n22 = 0;
                            while (true) {
                                float[] fArray2;
                                JsonValue jsonValue22;
                                if ((jsonValue22 = jsonValue21.get("vertices")) == null) {
                                    fArray2 = bl ? new float[n20] : fArray;
                                } else {
                                    fArray2 = new float[n20];
                                    int n23 = jsonValue21.getInt("offset", 0);
                                    SpineUtils.arraycopy(jsonValue22.asFloatArray(), 0, fArray2, n23, jsonValue22.size);
                                    if (f6 != 1.0f) {
                                        int n24 = n23;
                                        int n25 = n24 + jsonValue22.size;
                                        while (n24 < n25) {
                                            int n26 = n24++;
                                            fArray2[n26] = fArray2[n26] * f6;
                                        }
                                    }
                                    if (!bl) {
                                        for (int i = 0; i < n20; ++i) {
                                            int n27 = i;
                                            fArray2[n27] = fArray2[n27] + fArray[i];
                                        }
                                    }
                                }
                                deformTimeline.setFrame(n21, f50, fArray2);
                                JsonValue jsonValue23 = jsonValue21.next;
                                if (jsonValue23 == null) break;
                                float f51 = jsonValue23.getFloat("time", 0.0f);
                                JsonValue jsonValue24 = jsonValue21.get("curve");
                                if (jsonValue24 != null) {
                                    n22 = this.readCurve(jsonValue24, deformTimeline, n22, n21, 0, f50, f51, 0.0f, 1.0f, 1.0f);
                                }
                                f50 = f51;
                                jsonValue21 = jsonValue23;
                                ++n21;
                            }
                            deformTimeline.shrink(n22);
                            array.add(deformTimeline);
                        } else if (string5.equals("sequence")) {
                            var16_80 = new Animation.SequenceTimeline(n19, ((SlotData)object).index, attachment);
                            float f52 = 0.0f;
                            int n28 = 0;
                            while (jsonValue21 != null) {
                                float f53 = jsonValue21.getFloat("delay", f52);
                                ((Animation.SequenceTimeline)var16_80).setFrame(n28, jsonValue21.getFloat("time", 0.0f), Sequence.SequenceMode.valueOf(jsonValue21.getString("mode", "hold")), jsonValue21.getInt("index", 0), f53);
                                f52 = f53;
                                jsonValue21 = jsonValue21.next;
                                ++n28;
                            }
                            array.add((Animation.Timeline)var16_80);
                        }
                        jsonValue20 = jsonValue20.next;
                    }
                    jsonValue19 = jsonValue19.next;
                }
                jsonValue18 = jsonValue18.next;
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.get("drawOrder");
        if (jsonValue4 != null) {
            Animation.DrawOrderTimeline drawOrderTimeline = new Animation.DrawOrderTimeline(jsonValue4.size);
            int n29 = skeletonData.slots.size;
            int n30 = 0;
            JsonValue jsonValue25 = jsonValue4.child;
            while (jsonValue25 != null) {
                int[] nArray = null;
                JsonValue jsonValue26 = jsonValue25.get("offsets");
                if (jsonValue26 != null) {
                    nArray = new int[n29];
                    for (int i = n29 - 1; i >= 0; --i) {
                        nArray[i] = -1;
                    }
                    int[] nArray2 = new int[n29 - jsonValue26.size];
                    int n31 = 0;
                    int n32 = 0;
                    JsonValue jsonValue27 = jsonValue26.child;
                    while (jsonValue27 != null) {
                        SlotData slotData = skeletonData.findSlot(jsonValue27.getString("slot"));
                        if (slotData == null) {
                            throw new SerializationException("Slot not found: " + jsonValue27.getString("slot"));
                        }
                        while (n31 != slotData.index) {
                            nArray2[n32++] = n31++;
                        }
                        nArray[n31 + jsonValue27.getInt((String)"offset")] = n31++;
                        jsonValue27 = jsonValue27.next;
                    }
                    while (n31 < n29) {
                        nArray2[n32++] = n31++;
                    }
                    for (int i = n29 - 1; i >= 0; --i) {
                        if (nArray[i] != -1) continue;
                        nArray[i] = nArray2[--n32];
                    }
                }
                drawOrderTimeline.setFrame(n30, jsonValue25.getFloat("time", 0.0f), nArray);
                jsonValue25 = jsonValue25.next;
                ++n30;
            }
            array.add(drawOrderTimeline);
        }
        if ((jsonValue2 = jsonValue.get("events")) != null) {
            Animation.EventTimeline eventTimeline = new Animation.EventTimeline(jsonValue2.size);
            int n33 = 0;
            JsonValue jsonValue28 = jsonValue2.child;
            while (jsonValue28 != null) {
                EventData eventData = skeletonData.findEvent(jsonValue28.getString("name"));
                if (eventData == null) {
                    throw new SerializationException("Event not found: " + jsonValue28.getString("name"));
                }
                Event event = new Event(jsonValue28.getFloat("time", 0.0f), eventData);
                event.intValue = jsonValue28.getInt("int", eventData.intValue);
                event.floatValue = jsonValue28.getFloat("float", eventData.floatValue);
                event.stringValue = jsonValue28.getString("string", eventData.stringValue);
                if (event.getData().audioPath != null) {
                    event.volume = jsonValue28.getFloat("volume", eventData.volume);
                    event.balance = jsonValue28.getFloat("balance", eventData.balance);
                }
                eventTimeline.setFrame(n33, event);
                jsonValue28 = jsonValue28.next;
                ++n33;
            }
            array.add(eventTimeline);
        }
        array.shrink();
        float f54 = 0.0f;
        T[] TArray = array.items;
        int n34 = array.size;
        for (int i = 0; i < n34; ++i) {
            f54 = Math.max(f54, ((Animation.Timeline)TArray[i]).getDuration());
        }
        skeletonData.animations.add(new Animation(string, array, f54));
    }

    private Animation.Timeline readTimeline(JsonValue jsonValue, Animation.CurveTimeline1 curveTimeline1, float f, float f2) {
        float f3 = jsonValue.getFloat("time", 0.0f);
        float f4 = jsonValue.getFloat("value", f) * f2;
        int n = 0;
        int n2 = 0;
        while (true) {
            curveTimeline1.setFrame(n, f3, f4);
            JsonValue jsonValue2 = jsonValue.next;
            if (jsonValue2 == null) {
                curveTimeline1.shrink(n2);
                return curveTimeline1;
            }
            float f5 = jsonValue2.getFloat("time", 0.0f);
            float f6 = jsonValue2.getFloat("value", f) * f2;
            JsonValue jsonValue3 = jsonValue.get("curve");
            if (jsonValue3 != null) {
                n2 = this.readCurve(jsonValue3, curveTimeline1, n2, n, 0, f3, f5, f4, f6, f2);
            }
            f3 = f5;
            f4 = f6;
            jsonValue = jsonValue2;
            ++n;
        }
    }

    private Animation.Timeline readTimeline(JsonValue jsonValue, Animation.CurveTimeline2 curveTimeline2, String string, String string2, float f, float f2) {
        float f3 = jsonValue.getFloat("time", 0.0f);
        float f4 = jsonValue.getFloat(string, f) * f2;
        float f5 = jsonValue.getFloat(string2, f) * f2;
        int n = 0;
        int n2 = 0;
        while (true) {
            curveTimeline2.setFrame(n, f3, f4, f5);
            JsonValue jsonValue2 = jsonValue.next;
            if (jsonValue2 == null) {
                curveTimeline2.shrink(n2);
                return curveTimeline2;
            }
            float f6 = jsonValue2.getFloat("time", 0.0f);
            float f7 = jsonValue2.getFloat(string, f) * f2;
            float f8 = jsonValue2.getFloat(string2, f) * f2;
            JsonValue jsonValue3 = jsonValue.get("curve");
            if (jsonValue3 != null) {
                n2 = this.readCurve(jsonValue3, curveTimeline2, n2, n, 0, f3, f6, f4, f7, f2);
                n2 = this.readCurve(jsonValue3, curveTimeline2, n2, n, 1, f3, f6, f5, f8, f2);
            }
            f3 = f6;
            f4 = f7;
            f5 = f8;
            jsonValue = jsonValue2;
            ++n;
        }
    }

    int readCurve(JsonValue jsonValue, Animation.CurveTimeline curveTimeline, int n, int n2, int n3, float f, float f2, float f3, float f4, float f5) {
        if (jsonValue.isString()) {
            if (jsonValue.asString().equals("stepped")) {
                curveTimeline.setStepped(n2);
            }
            return n;
        }
        jsonValue = jsonValue.get(n3 << 2);
        float f6 = jsonValue.asFloat();
        jsonValue = jsonValue.next;
        float f7 = jsonValue.asFloat() * f5;
        jsonValue = jsonValue.next;
        float f8 = jsonValue.asFloat();
        jsonValue = jsonValue.next;
        float f9 = jsonValue.asFloat() * f5;
        SkeletonJson.setBezier(curveTimeline, n2, n3, n, f, f3, f6, f7, f8, f9, f2, f4);
        return n + 1;
    }

    static void setBezier(Animation.CurveTimeline curveTimeline, int n, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        curveTimeline.setBezier(n3, n, n2, f, f2, f3, f4, f5, f6, f7, f8);
    }

    static class LinkedMesh {
        String parent;
        String skin;
        int slotIndex;
        MeshAttachment mesh;
        boolean inheritTimelines;

        public LinkedMesh(MeshAttachment meshAttachment, String string, int n, String string2, boolean bl) {
            this.mesh = meshAttachment;
            this.skin = string;
            this.slotIndex = n;
            this.parent = string2;
            this.inheritTimelines = bl;
        }
    }
}

