/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.IntArray;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;

public class JsonWriter
extends Writer {
    Writer writer;
    private final IntArray stack;
    private int current;
    private boolean named;

    public JsonWriter pop() throws IOException {
        if (this.named) {
            throw new IllegalStateException("Expected an object, array, or value since a name was set.");
        }
        this.writer.write((char)(this.current >> 1));
        this.current = this.stack.size == 0 ? 0 : this.stack.items[--this.stack.size];
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        while (this.stack.size > 0) {
            this.pop();
        }
        this.writer.close();
    }

    public static enum OutputType {
        json,
        javascript,
        minimal;

        private static Pattern javascriptPattern;
        private static Pattern minimalNamePattern;
        private static Pattern minimalValuePattern;

        public String quoteValue(Object value) {
            int length;
            if (value == null) {
                return "null";
            }
            String string = value.toString();
            if (value instanceof Number || value instanceof Boolean) {
                return string;
            }
            boolean quote = false;
            block4: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case '\\': {
                        string = OutputType.escape(string, i);
                        quote = true;
                        break block4;
                    }
                    case '\"': {
                        quote = true;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
            if (!(this != minimal || string.equals("true") || string.equals("false") || string.equals("null") || string.contains("//") || string.contains("/*") || (length = string.length()) <= 0 || string.charAt(length - 1) == ' ' || !minimalValuePattern.matcher(string).matches())) {
                return string;
            }
            return quote ? OutputType.escapeQuote(string) : "\"" + string + "\"";
        }

        public String quoteName(String value) {
            boolean quote = false;
            block8: for (int i = 0; i < value.length(); ++i) {
                switch (value.charAt(i)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case '\\': {
                        value = OutputType.escape(value, i);
                        quote = true;
                        break block8;
                    }
                    case '\"': {
                        quote = true;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
            switch (this) {
                case minimal: {
                    if (!value.contains("//") && !value.contains("/*") && minimalNamePattern.matcher(value).matches()) {
                        return value;
                    }
                }
                case javascript: {
                    if (!javascriptPattern.matcher(value).matches()) break;
                    return value;
                }
            }
            return quote ? OutputType.escapeQuote(value) : "\"" + value + "\"";
        }

        private static String escape(String value, int i) {
            StringBuilder buffer = new StringBuilder(value.length() + 6);
            buffer.append(value, 0, i);
            while (i < value.length()) {
                char c = value.charAt(i);
                switch (c) {
                    case '\\': {
                        buffer.append("\\\\");
                        break;
                    }
                    case '\r': {
                        buffer.append("\\r");
                        break;
                    }
                    case '\n': {
                        buffer.append("\\n");
                        break;
                    }
                    case '\t': {
                        buffer.append("\\t");
                        break;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
                ++i;
            }
            return buffer.toString();
        }

        private static String escapeQuote(String value) {
            StringBuilder buffer = new StringBuilder(value.length() + 6);
            buffer.append('\"');
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\"') {
                    buffer.append("\\\"");
                    continue;
                }
                buffer.append(c);
            }
            buffer.append('\"');
            return buffer.toString();
        }

        static {
            javascriptPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
            minimalNamePattern = Pattern.compile("^[^\":,}/ ][^:]*$");
            minimalValuePattern = Pattern.compile("^[^\":,{\\[\\]/ ][^}\\],]*$");
        }
    }
}

