/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import java.io.BufferedWriter;
import java.io.Writer;

public class JsonRollback {
    public static void main(String[] stringArray) throws Exception {
        Object object;
        JsonValue jsonValue;
        JsonValue jsonValue2;
        JsonValue jsonValue3;
        String string;
        if (stringArray.length != 2 && stringArray.length != 3) {
            System.out.println("Usage: <inputFile> <targetVersion> [outputFile]");
            System.exit(0);
        }
        if (!((string = stringArray[1]).equals("2.1") || string.equals("3.7") || string.equals("3.8"))) {
            System.out.println("ERROR: Target version must be: 2.1, 3.7, or 3.8");
            System.out.println("Use the Spine editor JSON export to for versions 4.0+.");
            System.out.println("Usage: <inputFile> <toVersion> [outputFile]");
            System.exit(0);
        }
        if ((jsonValue3 = (jsonValue2 = (JsonValue)new Json().fromJson(null, new FileHandle(stringArray[0]))).get("skeleton")) == null) {
            jsonValue3 = new JsonValue(JsonValue.ValueType.object);
            jsonValue3.name = "skeleton";
            jsonValue2.addChildFirst(jsonValue3);
        }
        if ((jsonValue = jsonValue3.get("spine")) != null) {
            jsonValue.set(string + "-from-" + jsonValue.asString());
        } else {
            jsonValue3.addChild("spine", new JsonValue(string));
        }
        if (string.equals("2.1")) {
            String string2;
            Object object2;
            JsonRollback.setValue(jsonValue2, "skinnedmesh", "skins", "*", "*", "*", "type", "weightedmesh");
            JsonRollback.delete(jsonValue2, "animations", "*", "bones", "*", "shear");
            JsonRollback.rename(jsonValue2, "ffd", "animations", "*", "deform");
            for (JsonValue jsonValue4 : JsonRollback.find(jsonValue2, new Array<JsonValue>(), 0, "skins", "*", "*", "*", "type", "mesh")) {
                if (jsonValue4.parent.get((String)"uvs").size == jsonValue4.parent.get((String)"vertices").size) continue;
                jsonValue4.set("skinnedmesh");
            }
            for (JsonValue jsonValue4 : JsonRollback.find(jsonValue2, new Array<JsonValue>(), 0, "skins", "*", "*", "*", "type", "linkedmesh")) {
                object2 = jsonValue4.parent.parent.name.replaceAll("", "");
                string2 = jsonValue4.parent.getString("skin", "default");
                String string3 = jsonValue4.parent.getString("parent");
                if (JsonRollback.find((JsonValue)jsonValue2, new Array<JsonValue>(), (int)0, (String[])new StringBuilder().append((String)"skins~~").append((String)string2).append((String)"~~").append((String)object2).append((String)"~~").append((String)string3).append((String)"~~type~~skinnedmesh").toString().split((String)"~~")).size <= 0) continue;
                jsonValue4.set("weightedlinkedmesh");
            }
            for (JsonValue jsonValue4 : JsonRollback.find(jsonValue2, new Array<JsonValue>(), 0, "skins", "*", "*", "*", "type", "boundingbox")) {
                if (jsonValue4.parent.getInt("vertexCount") * 2 == jsonValue4.parent.get((String)"vertices").size) continue;
                jsonValue4.parent.parent.remove(jsonValue4.parent.name);
            }
            for (JsonValue jsonValue4 : JsonRollback.find(jsonValue2, new Array<JsonValue>(), 0, "skins", "*", "*", "*", "type", "path")) {
                object2 = jsonValue4.parent.name;
                jsonValue4.parent.parent.remove((String)object2);
                string2 = jsonValue4.parent.parent.name;
                JsonRollback.delete(jsonValue2, new String[]{"animations", "*", "ffd", "*", string2, object2});
            }
            for (JsonValue jsonValue4 : JsonRollback.find(jsonValue2, new Array<JsonValue>(), 0, "animations", "*", "ik", "*")) {
                object2 = jsonValue4.child;
                while (object2 != null) {
                    if (!((JsonValue)object2).has("bendPositive")) {
                        ((JsonValue)object2).addChild("bendPositive", new JsonValue(true));
                    }
                    object2 = ((JsonValue)object2).next;
                }
            }
            object = jsonValue2.getChild("transform");
            while (object != null) {
                JsonValue jsonValue4;
                jsonValue4 = ((JsonValue)object).remove("bones");
                if (jsonValue4 != null) {
                    ((JsonValue)object).addChild("bone", new JsonValue(jsonValue4.child.asString()));
                }
                object = ((JsonValue)object).next;
            }
        } else if (string.equals("3.7")) {
            object = jsonValue2.get("skins");
            if (object != null && ((JsonValue)object).isArray()) {
                JsonValue jsonValue5 = new JsonValue(JsonValue.ValueType.object);
                JsonValue jsonValue6 = ((JsonValue)object).child;
                while (jsonValue6 != null) {
                    JsonValue jsonValue7 = jsonValue6.get("attachments");
                    if (jsonValue7 != null) {
                        jsonValue5.addChild(jsonValue6.getString("name"), jsonValue6.get("attachments"));
                    }
                    jsonValue6 = jsonValue6.next;
                }
                jsonValue2.remove("skins");
                jsonValue2.addChild("skins", jsonValue5);
            }
            JsonRollback.rollbackCurves(jsonValue2.get("animations"));
        } else if (string.equals("3.8")) {
            JsonRollback.linearCurves(jsonValue2.get("animations"));
            JsonRollback.rename(jsonValue2, "angle", "animations", "*", "bones", "*", "rotate", "value");
            JsonRollback.constraintNames(jsonValue2, "transform");
            JsonRollback.constraintNames(jsonValue2, "path");
            JsonRollback.constraintNames(jsonValue2, "animations", "*", "transform", "*");
            JsonRollback.constraintNames(jsonValue2, "animations", "*", "path", "*");
        }
        if (stringArray.length == 3) {
            System.out.println("Writing: " + stringArray[2]);
            object = new BufferedWriter(new FileHandle(stringArray[2]).writer(false, "UTF-8"), 16384);
            jsonValue2.prettyPrint(JsonWriter.OutputType.json, (Writer)object);
            ((BufferedWriter)object).close();
        } else {
            System.out.println(jsonValue2.prettyPrint(JsonWriter.OutputType.json, 130));
        }
    }

    private static void log(String string) {
        System.out.println(string);
    }

    private static void constraintNames(JsonValue jsonValue, String ... stringArray) {
        for (JsonValue jsonValue2 : JsonRollback.find(jsonValue, new Array<JsonValue>(), 0, stringArray)) {
            JsonValue jsonValue3 = jsonValue2.child;
            while (jsonValue3 != null) {
                JsonValue jsonValue4 = jsonValue3.child;
                while (jsonValue4 != null) {
                    if (jsonValue4.name.equals("mixRotate")) {
                        jsonValue4.name = "rotateMix";
                    } else if (jsonValue4.name.equals("mixX") || jsonValue4.name.equals("mixY")) {
                        jsonValue4.name = "translateMix";
                    } else if (jsonValue4.name.equals("mixScaleX") || jsonValue4.name.equals("mixScaleY")) {
                        jsonValue4.name = "scaleMix";
                    } else if (jsonValue4.name.equals("mixShearX") || jsonValue4.name.equals("mixShearY")) {
                        jsonValue4.name = "shearMix";
                    }
                    jsonValue4 = jsonValue4.next;
                }
                jsonValue3 = jsonValue3.next;
            }
        }
    }

    private static void linearCurves(JsonValue jsonValue) {
        Object object;
        if (jsonValue == null) {
            return;
        }
        if (jsonValue.isObject() && jsonValue.parent.isArray() && jsonValue.parent.name != null) {
            object = jsonValue.parent.name;
            if (((String)object).equals("translatex") || ((String)object).equals("translatey") || ((String)object).equals("scalex") || ((String)object).equals("scaley") || ((String)object).equals("shearx") || ((String)object).equals("sheary") || ((String)object).equals("rgb") || ((String)object).equals("rgb2") || ((String)object).equals("alpha")) {
                jsonValue.parent.remove();
                JsonRollback.log("Separate timelines removed: " + (String)object);
            }
            if (((String)object).equals("rgba")) {
                jsonValue.parent.name = "color";
            } else if (((String)object).equals("rgba2")) {
                jsonValue.parent.name = "twoColor";
            }
        }
        if ((object = jsonValue.get("curve")) == null) {
            JsonValue jsonValue2 = jsonValue.child;
            while (jsonValue2 != null) {
                JsonRollback.linearCurves(jsonValue2);
                jsonValue2 = jsonValue2.next;
            }
            return;
        }
        if (!((JsonValue)object).isString()) {
            ((JsonValue)object).remove();
            JsonRollback.log("Bezier curve changed to linear.");
        }
    }

    private static void rollbackCurves(JsonValue jsonValue) {
        JsonValue jsonValue2;
        if (jsonValue == null) {
            return;
        }
        if (jsonValue.isObject() && jsonValue.parent.isArray()) {
            if (!jsonValue.has("time")) {
                jsonValue.addChild("time", new JsonValue(0.0));
            }
            if (jsonValue.parent.name != null) {
                if (jsonValue.parent.name.equals("rotate") && !jsonValue.has("angle")) {
                    jsonValue.addChild("angle", new JsonValue(0.0));
                } else if (jsonValue.parent.name.equals("scale")) {
                    if (!jsonValue.has("x")) {
                        jsonValue.addChild("x", new JsonValue(1.0));
                    }
                    if (!jsonValue.has("y")) {
                        jsonValue.addChild("y", new JsonValue(1.0));
                    }
                }
            }
        }
        if ((jsonValue2 = jsonValue.get("curve")) == null) {
            JsonValue jsonValue3 = jsonValue.child;
            while (jsonValue3 != null) {
                JsonRollback.rollbackCurves(jsonValue3);
                jsonValue3 = jsonValue3.next;
            }
            return;
        }
        if (jsonValue2.isNumber()) {
            jsonValue2.addChild(new JsonValue(jsonValue2.asFloat()));
            jsonValue2.setType(JsonValue.ValueType.array);
            jsonValue2.addChild(new JsonValue(jsonValue.getFloat("c2", 0.0f)));
            jsonValue2.addChild(new JsonValue(jsonValue.getFloat("c3", 1.0f)));
            jsonValue2.addChild(new JsonValue(jsonValue.getFloat("c4", 1.0f)));
            jsonValue.remove("c2");
            jsonValue.remove("c3");
            jsonValue.remove("c4");
        }
    }

    static void setValue(JsonValue jsonValue, String string, String ... stringArray) {
        for (JsonValue jsonValue2 : JsonRollback.find(jsonValue, new Array<JsonValue>(), 0, stringArray)) {
            jsonValue2.set(string);
        }
    }

    static void rename(JsonValue jsonValue, String string, String ... stringArray) {
        for (JsonValue jsonValue2 : JsonRollback.find(jsonValue, new Array<JsonValue>(), 0, stringArray)) {
            jsonValue2.name = string;
        }
    }

    static void delete(JsonValue jsonValue, String ... stringArray) {
        for (JsonValue jsonValue2 : JsonRollback.find(jsonValue, new Array<JsonValue>(), 0, stringArray)) {
            jsonValue2.parent.remove(jsonValue2.name);
        }
    }

    static Array<JsonValue> find(JsonValue jsonValue, Array<JsonValue> array, int n, String ... stringArray) {
        String string = stringArray[n];
        if (jsonValue.name == null) {
            if (string.equals("*") && n == stringArray.length - 1) {
                array.add(jsonValue);
            } else if (jsonValue.has(string)) {
                return JsonRollback.find(jsonValue.get(string), array, n, stringArray);
            }
        } else if (string.equals("*") || jsonValue.name.equals(string)) {
            if (++n == stringArray.length || n == stringArray.length - 1 && jsonValue.isString() && jsonValue.asString().equals(stringArray[n])) {
                array.add(jsonValue);
            } else {
                JsonValue jsonValue2 = jsonValue.child;
                while (jsonValue2 != null) {
                    JsonRollback.find(jsonValue2, array, n, stringArray);
                    jsonValue2 = jsonValue2.next;
                }
            }
        }
        return array;
    }
}

