/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.esotericsoftware.spine.Pose;
import com.esotericsoftware.spine.PosedData;

public abstract class Posed<D extends PosedData<P>, P extends Pose, A extends P> {
    final D data;
    final A pose;
    final A constrained;
    A applied;

    public Posed(D d, A a, A a2) {
        if (d == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = d;
        this.pose = a;
        this.constrained = a2;
        this.applied = a;
    }

    public void setupPose() {
        this.pose.set(((PosedData)this.data).setup);
    }

    public D getData() {
        return this.data;
    }

    public A getAppliedPose() {
        return this.applied;
    }

    void pose() {
        this.applied = this.pose;
    }

    void constrained() {
        this.applied = this.constrained;
    }

    void reset() {
        this.constrained.set(this.pose);
    }

    public String toString() {
        return ((PosedData)this.data).name;
    }
}

