/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.BonePose;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonBounds;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotPose;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;

public class SkeletonRendererDebug {
    public static final Color boneLineColor = Color.RED;
    public static final Color boneOriginColor = Color.GREEN;
    public static final Color attachmentLineColor = new Color(0.0f, 0.0f, 1.0f, 0.5f);
    public static final Color triangleLineColor = new Color(1.0f, 0.64f, 0.0f, 0.5f);
    public static final Color aabbColor = new Color(0.0f, 1.0f, 0.0f, 0.5f);
    private final ShapeRenderer shapes;
    private boolean drawBones = true;
    private boolean drawRegionAttachments = true;
    private boolean drawBoundingBoxes = true;
    private boolean drawPoints = true;
    private boolean drawMeshHull = true;
    private boolean drawMeshTriangles = true;
    private boolean drawPaths = true;
    private boolean drawClipping = true;
    private final SkeletonBounds bounds = new SkeletonBounds();
    private final FloatArray vertices = new FloatArray(32);
    private float scale = 1.0f;
    private float boneWidth = 2.0f;
    private boolean premultipliedAlpha;
    private final Vector2 temp1 = new Vector2();
    private final Vector2 temp2 = new Vector2();

    public SkeletonRendererDebug() {
        this.shapes = new ShapeRenderer();
    }

    /*
     * WARNING - void declaration
     */
    public void draw(Skeleton skeleton) {
        Object object;
        Object object2;
        Object object3;
        int n;
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        Gdx.gl.glEnable(3042);
        int n2 = this.premultipliedAlpha ? 1 : 770;
        Gdx.gl.glBlendFunc(n2, 771);
        ShapeRenderer shapeRenderer = this.shapes;
        Bone[] boneArray = (Bone[])skeleton.bones.items;
        Slot[] slotArray = (Slot[])skeleton.slots.items;
        int n3 = skeleton.bones.size;
        int n4 = skeleton.slots.size;
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        if (this.drawBones) {
            for (n = 0; n < n3; ++n) {
                object3 = boneArray[n];
                if (((Bone)object3).parent == null || !((Bone)object3).active) continue;
                float f = ((BoneData)((Bone)object3).data).length;
                float f2 = this.boneWidth;
                if (f == 0.0f) {
                    f = 8.0f;
                    f2 /= 2.0f;
                    shapeRenderer.setColor(boneOriginColor);
                } else {
                    shapeRenderer.setColor(boneLineColor);
                }
                object2 = (BonePose)((Bone)object3).applied;
                float f3 = f * ((BonePose)object2).a + ((BonePose)object2).worldX;
                float f4 = f * ((BonePose)object2).c + ((BonePose)object2).worldY;
                shapeRenderer.rectLine(((BonePose)object2).worldX, ((BonePose)object2).worldY, f3, f4, f2 * this.scale);
            }
            shapeRenderer.x(skeleton.x, skeleton.y, 4.0f * this.scale);
        }
        if (this.drawPoints) {
            shapeRenderer.setColor(boneOriginColor);
            for (n = 0; n < n4; ++n) {
                Attachment attachment;
                object3 = slotArray[n];
                if (!((Slot)object3).bone.active || !((attachment = ((SlotPose)((Slot)object3).applied).attachment) instanceof PointAttachment)) continue;
                PointAttachment pointAttachment = (PointAttachment)attachment;
                pointAttachment.computeWorldPosition((BonePose)((Slot)object3).bone.applied, this.temp1);
                this.temp2.set(8.0f, 0.0f).rotate(pointAttachment.computeWorldRotation((BonePose)((Slot)object3).bone.applied));
                shapeRenderer.rectLine(this.temp1, this.temp2, this.boneWidth / 2.0f * this.scale);
            }
        }
        shapeRenderer.end();
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        if (this.drawRegionAttachments) {
            shapeRenderer.setColor(attachmentLineColor);
            for (n = 0; n < n4; ++n) {
                Object object4;
                object3 = slotArray[n];
                if (!((Slot)object3).bone.active || !((object4 = ((SlotPose)((Slot)object3).pose).attachment) instanceof RegionAttachment)) continue;
                RegionAttachment regionAttachment = (RegionAttachment)object4;
                object4 = this.vertices.items;
                regionAttachment.computeWorldVertices((Slot)object3, (float[])object4, 0, 2);
                shapeRenderer.line((float)object4[0], (float)object4[1], (float)object4[2], (float)object4[3]);
                shapeRenderer.line((float)object4[2], (float)object4[3], (float)object4[4], (float)object4[5]);
                shapeRenderer.line((float)object4[4], (float)object4[5], (float)object4[6], (float)object4[7]);
                shapeRenderer.line((float)object4[6], (float)object4[7], (float)object4[0], (float)object4[1]);
            }
        }
        if (this.drawMeshHull || this.drawMeshTriangles) {
            for (n = 0; n < n4; ++n) {
                Object object5;
                reference var16_51;
                Object object6;
                object3 = slotArray[n];
                if (!((Slot)object3).bone.active || !((object6 = ((SlotPose)((Slot)object3).pose).attachment) instanceof MeshAttachment)) continue;
                MeshAttachment meshAttachment = (MeshAttachment)object6;
                object6 = this.vertices.setSize(meshAttachment.getWorldVerticesLength());
                meshAttachment.computeWorldVertices(skeleton, (Slot)object3, 0, meshAttachment.getWorldVerticesLength(), (float[])object6, 0, 2);
                object2 = meshAttachment.getTriangles();
                int n5 = meshAttachment.getHullLength();
                if (this.drawMeshTriangles) {
                    shapeRenderer.setColor(triangleLineColor);
                    int n6 = ((Object)object2).length;
                    for (int i = 0; i < n6; i += 3) {
                        var16_51 = object2[i] * 2;
                        object5 = object2[i + 1] * 2;
                        reference var18_57 = object2[i + 2] * 2;
                        shapeRenderer.triangle((float)object6[var16_51], (float)object6[var16_51 + true], (float)object6[object5], (float)object6[object5 + 1], (float)object6[var18_57], (float)object6[var18_57 + true]);
                    }
                }
                if (!this.drawMeshHull || n5 <= 0) continue;
                shapeRenderer.setColor(attachmentLineColor);
                Object object7 = object6[n5 - 2];
                Object object8 = object6[n5 - 1];
                object5 = n5;
                for (var16_51 = (reference)false; var16_51 < object5; var16_51 += 2) {
                    Object object9 = object6[var16_51];
                    object = object6[var16_51 + true];
                    shapeRenderer.line((float)object9, (float)object, (float)object7, (float)object8);
                    object7 = object9;
                    object8 = object;
                }
            }
        }
        if (this.drawBoundingBoxes) {
            SkeletonBounds skeletonBounds = this.bounds;
            skeletonBounds.update(skeleton, true);
            shapeRenderer.setColor(aabbColor);
            shapeRenderer.rect(skeletonBounds.getMinX(), skeletonBounds.getMinY(), skeletonBounds.getWidth(), skeletonBounds.getHeight());
            object3 = skeletonBounds.getPolygons();
            Array<BoundingBoxAttachment> array = skeletonBounds.getBoundingBoxes();
            int n7 = ((Array)object3).size;
            for (int i = 0; i < n7; ++i) {
                FloatArray floatArray = ((FloatArray[])((Array)object3).items)[i];
                shapeRenderer.setColor(((BoundingBoxAttachment[])array.items)[i].getColor());
                shapeRenderer.polygon(floatArray.items, 0, floatArray.size);
            }
        }
        if (this.drawClipping) {
            for (int i = 0; i < n4; ++i) {
                Attachment attachment;
                object3 = slotArray[i];
                if (!((Slot)object3).bone.active || !((attachment = ((SlotPose)((Slot)object3).pose).attachment) instanceof ClippingAttachment)) continue;
                ClippingAttachment clippingAttachment = (ClippingAttachment)attachment;
                int n8 = clippingAttachment.getWorldVerticesLength();
                float[] fArray = this.vertices.setSize(n8);
                clippingAttachment.computeWorldVertices(skeleton, (Slot)object3, 0, n8, fArray, 0, 2);
                shapeRenderer.setColor(clippingAttachment.getColor());
                for (int j = 2; j < n8; j += 2) {
                    shapeRenderer.line(fArray[j - 2], fArray[j - 1], fArray[j], fArray[j + 1]);
                }
                shapeRenderer.line(fArray[0], fArray[1], fArray[n8 - 2], fArray[n8 - 1]);
            }
        }
        if (this.drawPaths) {
            for (int i = 0; i < n4; ++i) {
                void var18_61;
                float f;
                float f2;
                Attachment attachment;
                object3 = slotArray[i];
                if (!((Slot)object3).bone.active || !((attachment = ((SlotPose)((Slot)object3).pose).attachment) instanceof PathAttachment)) continue;
                PathAttachment pathAttachment = (PathAttachment)attachment;
                int n9 = pathAttachment.getWorldVerticesLength();
                float[] fArray = this.vertices.setSize(n9);
                pathAttachment.computeWorldVertices(skeleton, (Slot)object3, 0, n9, fArray, 0, 2);
                Color color = pathAttachment.getColor();
                float f6 = fArray[2];
                float f7 = fArray[3];
                float f8 = 0.0f;
                float f9 = 0.0f;
                if (pathAttachment.getClosed()) {
                    shapeRenderer.setColor(color);
                    float f10 = fArray[0];
                    object = fArray[1];
                    f2 = fArray[n9 - 2];
                    f = fArray[n9 - 1];
                    f8 = fArray[n9 - 4];
                    f9 = fArray[n9 - 3];
                    shapeRenderer.curve(f6, f7, f10, (float)object, f2, f, f8, f9, 32);
                    shapeRenderer.setColor(Color.LIGHT_GRAY);
                    shapeRenderer.line(f6, f7, f10, (float)object);
                    shapeRenderer.line(f8, f9, f2, f);
                }
                n9 -= 4;
                int j = 4;
                while (var18_61 < n9) {
                    object = fArray[var18_61];
                    f2 = fArray[var18_61 + true];
                    f = fArray[var18_61 + 2];
                    float f3 = fArray[var18_61 + 3];
                    f8 = fArray[var18_61 + 4];
                    f9 = fArray[var18_61 + 5];
                    shapeRenderer.setColor(color);
                    shapeRenderer.curve(f6, f7, (float)object, f2, f, f3, f8, f9, 32);
                    shapeRenderer.setColor(Color.LIGHT_GRAY);
                    shapeRenderer.line(f6, f7, (float)object, f2);
                    shapeRenderer.line(f8, f9, f, f3);
                    f6 = f8;
                    f7 = f9;
                    var18_61 += 6;
                }
            }
        }
        shapeRenderer.end();
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        if (this.drawBones) {
            shapeRenderer.setColor(boneOriginColor);
            for (int i = 0; i < n3; ++i) {
                object3 = boneArray[i];
                if (!((Bone)object3).active) continue;
                shapeRenderer.circle(((BonePose)((Bone)object3).applied).worldX, ((BonePose)((Bone)object3).applied).worldY, 3.0f * this.scale, 8);
            }
        }
        if (this.drawPoints) {
            shapeRenderer.setColor(boneOriginColor);
            for (int i = 0; i < n4; ++i) {
                Attachment attachment;
                object3 = slotArray[i];
                if (!((Slot)object3).bone.active || !((attachment = ((SlotPose)((Slot)object3).pose).attachment) instanceof PointAttachment)) continue;
                PointAttachment pointAttachment = (PointAttachment)attachment;
                pointAttachment.computeWorldPosition((BonePose)((Slot)object3).bone.applied, this.temp1);
                shapeRenderer.circle(this.temp1.x, this.temp1.y, 3.0f * this.scale, 8);
            }
        }
        shapeRenderer.end();
    }

    public ShapeRenderer getShapeRenderer() {
        return this.shapes;
    }

    public void setBones(boolean bl) {
        this.drawBones = bl;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public void setRegionAttachments(boolean bl) {
        this.drawRegionAttachments = bl;
    }

    public void setBoundingBoxes(boolean bl) {
        this.drawBoundingBoxes = bl;
    }

    public void setMeshHull(boolean bl) {
        this.drawMeshHull = bl;
    }

    public void setMeshTriangles(boolean bl) {
        this.drawMeshTriangles = bl;
    }

    public void setPaths(boolean bl) {
        this.drawPaths = bl;
    }

    public void setPoints(boolean bl) {
        this.drawPoints = bl;
    }

    public void setClipping(boolean bl) {
        this.drawClipping = bl;
    }
}

